/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChild
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";

    public TestChild() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(JobConf conf, int numMaps, int numReds, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        conf.setBoolean(OLD_CONFIGS, oldConfigs);
        if (oldConfigs) {
            conf.set("mapred.child.java.opts", "-Xmx200m");
        } else {
            conf.set("mapreduce.map.java.opts", "-Xmx200m");
            conf.set("mapreduce.reduce.java.opts", REDUCE_OPTS_VAL);
        }
        conf.set("mapreduce.map.log.level", Level.OFF.toString());
        conf.set("mapreduce.reduce.log.level", Level.OFF.toString());
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.inDir, this.outDir, numMaps, numReds);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        Assertions.assertFalse((boolean)job.isConnected(), (String)"Job already has a job tracker connection, before it's submitted");
        job.submit();
        Assertions.assertTrue((boolean)job.isConnected(), (String)"Job doesn't have a job tracker connection, even though it's been submitted");
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assertions.assertTrue((boolean)fs.exists(this.outDir), (String)"Job output directory doesn't exit!");
        FileStatus[] list = fs.listStatus(this.outDir, (PathFilter)new OutputFilter());
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        Assertions.assertTrue((list.length == numPartFiles ? 1 : 0) != 0, (String)("Number of part-files is " + list.length + " and not " + numPartFiles));
        return job;
    }

    @Test
    public void testChild() throws Exception {
        try {
            this.submitAndValidateJob(this.createJobConf(), 1, 1, true);
            this.submitAndValidateJob(this.createJobConf(), 1, 1, false);
        }
        finally {
            this.tearDown();
        }
    }

    private static class OutputFilter
    implements PathFilter {
        private OutputFilter() {
        }

        public boolean accept(Path path) {
            return !path.getName().startsWith("_");
        }
    }

    static class MyReducer
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        MyReducer() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assertions.assertNotNull((Object)javaOpts, (String)"mapred.child.java.opts is null!");
                Assertions.assertEquals((Object)javaOpts, (Object)"-Xmx200m", (String)("mapred.child.java.opts has value of: " + javaOpts));
            } else {
                String reduceJavaOpts = conf.get("mapreduce.reduce.java.opts");
                Assertions.assertNotNull((Object)reduceJavaOpts, (String)"mapreduce.reduce.java.opts is null!");
                Assertions.assertEquals((Object)reduceJavaOpts, (Object)TestChild.REDUCE_OPTS_VAL, (String)("mapreduce.reduce.java.opts has value of: " + reduceJavaOpts));
            }
            Level logLevel = Level.toLevel((String)conf.get("mapreduce.reduce.log.level", Level.INFO.toString()));
            Assertions.assertEquals((Object)logLevel, (Object)Level.OFF, (String)("mapreduce.reduce.log.levelhas value of " + logLevel));
        }
    }

    static class MyMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        MyMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assertions.assertNotNull((Object)javaOpts, (String)"mapred.child.java.opts is null!");
                Assertions.assertEquals((Object)javaOpts, (Object)"-Xmx200m", (String)("mapred.child.java.opts has value of: " + javaOpts));
            } else {
                String mapJavaOpts = conf.get("mapreduce.map.java.opts");
                Assertions.assertNotNull((Object)mapJavaOpts, (String)"mapreduce.map.java.opts is null!");
                Assertions.assertEquals((Object)mapJavaOpts, (Object)"-Xmx200m", (String)("mapreduce.map.java.opts has value of: " + mapJavaOpts));
            }
            Level logLevel = Level.toLevel((String)conf.get("mapreduce.map.log.level", Level.INFO.toString()));
            Assertions.assertEquals((Object)logLevel, (Object)Level.OFF, (String)("mapreduce.map.log.levelhas value of " + logLevel));
        }
    }
}

