/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.MultithreadedMapRunner;
import org.apache.hadoop.mapreduce.lib.map.MultithreadedMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultithreadedMapRunner
extends HadoopTestCase {
    public TestMultithreadedMapRunner() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testOKRun() throws Exception {
        this.run(false, false);
    }

    @Test
    public void testIOExRun() throws Exception {
        this.run(true, false);
    }

    @Test
    public void testRuntimeExRun() throws Exception {
        this.run(false, true);
    }

    private void run(boolean ioEx, boolean rtEx) throws Exception {
        Path inDir = new Path("testing/mt/input");
        Path outDir = new Path("testing/mt/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        JobConf conf = this.createJobConf();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("a\nb\n\nc\nd\ne");
        file.close();
        conf.setJobName("mt");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IDMap.class);
        conf.setReducerClass(IDReduce.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setMapRunnerClass(MultithreadedMapRunner.class);
        conf.setInt(MultithreadedMapper.NUM_THREADS, 2);
        if (ioEx) {
            conf.setBoolean("multithreaded.ioException", true);
        }
        if (rtEx) {
            conf.setBoolean("multithreaded.runtimeException", true);
        }
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        if (job.isSuccessful()) {
            Assertions.assertFalse((ioEx || rtEx ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue((ioEx || rtEx ? 1 : 0) != 0);
        }
    }

    public static class IDReduce
    implements Reducer<LongWritable, Text, LongWritable, Text> {
        public void configure(JobConf job) {
        }

        public void reduce(LongWritable key, Iterator<Text> values, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                output.collect((Object)key, (Object)values.next());
            }
        }

        public void close() throws IOException {
        }
    }

    public static class IDMap
    implements Mapper<LongWritable, Text, LongWritable, Text> {
        private boolean ioEx = false;
        private boolean rtEx = false;

        public void configure(JobConf job) {
            this.ioEx = job.getBoolean("multithreaded.ioException", false);
            this.rtEx = job.getBoolean("multithreaded.runtimeException", false);
        }

        public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            if (this.ioEx) {
                throw new IOException();
            }
            if (this.rtEx) {
                throw new RuntimeException();
            }
            output.collect((Object)key, (Object)value);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void close() throws IOException {
        }
    }
}

