/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.ChainMapper;
import org.apache.hadoop.mapred.lib.ChainReducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChainMapReduce
extends HadoopTestCase {
    private static Path getFlagDir(boolean local) {
        Path flagDir = new Path("testing/chain/flags");
        if (local) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            flagDir = new Path(localPathRoot, flagDir);
        }
        return flagDir;
    }

    private static void cleanFlags(JobConf conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(TestChainMapReduce.getFlagDir(conf.getBoolean("localFS", true)), true);
        fs.mkdirs(TestChainMapReduce.getFlagDir(conf.getBoolean("localFS", true)));
    }

    private static void writeFlag(JobConf conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (TestChainMapReduce.getFlag(conf, flag)) {
            Assertions.fail((String)("Flag " + flag + " already exists"));
        }
        FSDataOutputStream file = fs.create(new Path(TestChainMapReduce.getFlagDir(conf.getBoolean("localFS", true)), flag));
        file.close();
    }

    private static boolean getFlag(JobConf conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(TestChainMapReduce.getFlagDir(conf.getBoolean("localFS", true)), flag));
    }

    public TestChainMapReduce() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testChain() throws Exception {
        Path inDir = new Path("testing/chain/input");
        Path outDir = new Path("testing/chain/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        JobConf conf = this.createJobConf();
        conf.setBoolean("localFS", this.isLocalFS());
        conf.setInt("mapreduce.job.maps", 1);
        TestChainMapReduce.cleanFlags(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir);
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("1\n2\n");
        file.close();
        conf.setJobName("chain");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.set("a", "X");
        JobConf mapAConf = new JobConf(false);
        mapAConf.set("a", "A");
        ChainMapper.addMapper((JobConf)conf, AMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)mapAConf);
        ChainMapper.addMapper((JobConf)conf, BMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)false, null);
        JobConf reduceConf = new JobConf(false);
        reduceConf.set("a", "C");
        ChainReducer.setReducer((JobConf)conf, CReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)reduceConf);
        ChainReducer.addMapper((JobConf)conf, DMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)false, null);
        JobConf mapEConf = new JobConf(false);
        mapEConf.set("a", "E");
        ChainReducer.addMapper((JobConf)conf, EMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)mapEConf);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "configure.A"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "configure.B"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "configure.C"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "configure.D"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "configure.E"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.A.value.1"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.A.value.2"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.B.value.1"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.B.value.2"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "reduce.C.value.2"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "reduce.C.value.1"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.D.value.1"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.D.value.2"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.E.value.1"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "map.E.value.2"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "close.A"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "close.B"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "close.C"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "close.D"));
        Assertions.assertTrue((boolean)TestChainMapReduce.getFlag(conf, "close.E"));
    }

    public static class IDReduce
    implements Reducer<LongWritable, Text, LongWritable, Text> {
        private JobConf conf;
        private String name;
        private String prop;
        private boolean byValue = false;

        public IDReduce(String name, String prop) {
            this.name = name;
            this.prop = prop;
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            Assertions.assertEquals((Object)this.prop, (Object)conf.get("a"));
            try {
                TestChainMapReduce.writeFlag(conf, "configure." + this.name);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void reduce(LongWritable key, Iterator<Text> values, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                Text value = values.next();
                TestChainMapReduce.writeFlag(this.conf, "reduce." + this.name + ".value." + value);
                key.set(10L);
                output.collect((Object)key, (Object)value);
                if (this.byValue) {
                    Assertions.assertEquals((long)10L, (long)key.get());
                } else {
                    Assertions.assertNotSame((Object)10, (Object)key.get());
                }
                key.set(11L);
            }
        }

        public void close() throws IOException {
            try {
                TestChainMapReduce.writeFlag(this.conf, "close." + this.name);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class IDMap
    implements Mapper<LongWritable, Text, LongWritable, Text> {
        private JobConf conf;
        private String name;
        private String prop;
        private boolean byValue;

        public IDMap(String name, String prop, boolean byValue) {
            this.name = name;
            this.prop = prop;
            this.byValue = byValue;
        }

        public void configure(JobConf conf) {
            this.conf = conf;
            Assertions.assertEquals((Object)this.prop, (Object)conf.get("a"));
            try {
                TestChainMapReduce.writeFlag(conf, "configure." + this.name);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
            TestChainMapReduce.writeFlag(this.conf, "map." + this.name + ".value." + value);
            key.set(10L);
            output.collect((Object)key, (Object)value);
            if (this.byValue) {
                Assertions.assertEquals((long)10L, (long)key.get());
            } else {
                Assertions.assertNotSame((Object)10, (Object)key.get());
            }
            key.set(11L);
        }

        public void close() throws IOException {
            try {
                TestChainMapReduce.writeFlag(this.conf, "close." + this.name);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class EMap
    extends IDMap {
        public EMap() {
            super("E", "E", true);
        }
    }

    public static class DMap
    extends IDMap {
        public DMap() {
            super("D", "X", false);
        }
    }

    public static class CReduce
    extends IDReduce {
        public CReduce() {
            super("C", "C");
        }
    }

    public static class BMap
    extends IDMap {
        public BMap() {
            super("B", "X", false);
        }
    }

    public static class AMap
    extends IDMap {
        public AMap() {
            super("A", "A", true);
        }
    }
}

