/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.lib.Chain;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChain {
    @Test
    public void testSetReducerWithReducerByValueAsTrue() throws Exception {
        JobConf jobConf = new JobConf();
        JobConf reducerConf = new JobConf();
        Chain.setReducer((JobConf)jobConf, MyReducer.class, Object.class, Object.class, Object.class, Object.class, (boolean)true, (JobConf)reducerConf);
        boolean reduceByValue = reducerConf.getBoolean("chain.reducer.byValue", false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)reduceByValue).withFailMessage("It should set chain.reducer.byValue as true in reducerConf when we give value as true", new Object[0])).isTrue();
    }

    @Test
    public void testSetReducerWithReducerByValueAsFalse() throws Exception {
        JobConf jobConf = new JobConf();
        JobConf reducerConf = new JobConf();
        Chain.setReducer((JobConf)jobConf, MyReducer.class, Object.class, Object.class, Object.class, Object.class, (boolean)false, (JobConf)reducerConf);
        boolean reduceByValue = reducerConf.getBoolean("chain.reducer.byValue", true);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)reduceByValue).withFailMessage("It should set chain.reducer.byValue as false in reducerConf when we give value as false", new Object[0])).isFalse();
    }

    static interface MyReducer
    extends Reducer<Object, Object, Object, Object> {
    }
}

