/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.join.CompositeInputFormat;
import org.apache.hadoop.mapred.join.CompositeRecordReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWrappedRecordReaderClassloader {
    @Test
    public void testClassLoader() throws Exception {
        JobConf job = new JobConf();
        Fake_ClassLoader classLoader = new Fake_ClassLoader();
        job.setClassLoader((ClassLoader)classLoader);
        Assertions.assertTrue((boolean)(job.getClassLoader() instanceof Fake_ClassLoader));
        FileSystem fs = FileSystem.get((Configuration)job);
        Path testdir = fs.makeQualified(new Path(System.getProperty("test.build.data", "/tmp")));
        Path base = new Path(testdir, "/empty");
        Path[] src = new Path[]{new Path(base, "i0"), new Path("i1"), new Path("i2")};
        job.set("mapreduce.join.expr", CompositeInputFormat.compose((String)"outer", IF_ClassLoaderChecker.class, (Path[])src));
        CompositeInputFormat inputFormat = new CompositeInputFormat();
        inputFormat.getRecordReader(inputFormat.getSplits(job, 1)[0], job, Reporter.NULL);
    }

    public static class RR_ClassLoaderChecker<K, V>
    implements RecordReader<K, V> {
        private Class<? extends K> keyclass;
        private Class<? extends V> valclass;

        public RR_ClassLoaderChecker(JobConf job) {
            Assertions.assertTrue((boolean)(job.getClassLoader() instanceof Fake_ClassLoader), (String)("The class loader has not been inherited from " + CompositeRecordReader.class.getSimpleName()));
            this.keyclass = job.getClass("test.fakeif.keyclass", NullWritable.class, WritableComparable.class);
            this.valclass = job.getClass("test.fakeif.valclass", NullWritable.class, WritableComparable.class);
        }

        public boolean next(K key, V value) throws IOException {
            return false;
        }

        public K createKey() {
            return (K)ReflectionUtils.newInstance(this.keyclass, null);
        }

        public V createValue() {
            return (V)ReflectionUtils.newInstance(this.valclass, null);
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    public static class IF_ClassLoaderChecker<K, V>
    implements InputFormat<K, V>,
    JobConfigurable {
        protected Class<? extends K> keyclass;
        protected Class<? extends V> valclass;

        public static void setKeyClass(JobConf job, Class<?> k) {
            job.setClass("test.fakeif.keyclass", k, WritableComparable.class);
        }

        public static void setValClass(JobConf job, Class<?> v) {
            job.setClass("test.fakeif.valclass", v, Writable.class);
        }

        public void configure(JobConf job) {
            this.keyclass = job.getClass("test.fakeif.keyclass", NullWritable.class, WritableComparable.class);
            this.valclass = job.getClass("test.fakeif.valclass", NullWritable.class, WritableComparable.class);
        }

        public InputSplit[] getSplits(JobConf conf, int splits) {
            return new InputSplit[]{new FakeSplit()};
        }

        public RecordReader<K, V> getRecordReader(InputSplit ignored, JobConf job, Reporter reporter) {
            return new RR_ClassLoaderChecker(job);
        }

        public static class FakeSplit
        implements InputSplit {
            public void write(DataOutput out) throws IOException {
            }

            public void readFields(DataInput in) throws IOException {
            }

            public long getLength() {
                return 0L;
            }

            public String[] getLocations() {
                return new String[0];
            }
        }
    }

    public static class Fake_ClassLoader
    extends ClassLoader {
    }
}

