/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.join.TupleWritable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTupleWritable {
    private TupleWritable makeTuple(Writable[] writs) {
        int i;
        Writable[] sub1 = new Writable[]{writs[1], writs[2]};
        Writable[] sub3 = new Writable[]{writs[4], writs[5]};
        Writable[] sub2 = new Writable[]{writs[3], new TupleWritable(sub3), writs[6]};
        Writable[] vals = new Writable[]{writs[0], new TupleWritable(sub1), new TupleWritable(sub2), writs[7], writs[8], writs[9]};
        TupleWritable ret = new TupleWritable(vals);
        for (i = 0; i < 6; ++i) {
            ret.setWritten(i);
        }
        ((TupleWritable)sub2[1]).setWritten(0);
        ((TupleWritable)sub2[1]).setWritten(1);
        ((TupleWritable)vals[1]).setWritten(0);
        ((TupleWritable)vals[1]).setWritten(1);
        for (i = 0; i < 3; ++i) {
            ((TupleWritable)vals[2]).setWritten(i);
        }
        return ret;
    }

    private Writable[] makeRandomWritables() {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        return writs;
    }

    private Writable[] makeRandomWritables(int numWrits) {
        Writable[] writs = this.makeRandomWritables();
        Writable[] manyWrits = new Writable[numWrits];
        for (int i = 0; i < manyWrits.length; ++i) {
            manyWrits[i] = writs[i % writs.length];
        }
        return manyWrits;
    }

    private int verifIter(Writable[] writs, TupleWritable t, int i) {
        for (Writable w : t) {
            if (w instanceof TupleWritable) {
                i = this.verifIter(writs, (TupleWritable)w, i);
                continue;
            }
            Assertions.assertEquals((Object)w, (Object)writs[i++], (String)"Bad value");
        }
        return i;
    }

    @Test
    public void testIterable() throws Exception {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TupleWritable t = new TupleWritable(writs);
        for (int i = 0; i < 6; ++i) {
            t.setWritten(i);
        }
        this.verifIter(writs, t, 0);
    }

    @Test
    public void testNestedIterable() throws Exception {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TupleWritable sTuple = this.makeTuple(writs);
        Assertions.assertEquals((int)writs.length, (int)this.verifIter(writs, sTuple, 0), (String)"Bad count");
    }

    @Test
    public void testWritable() throws Exception {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TupleWritable sTuple = this.makeTuple(writs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertEquals((Object)sTuple, (Object)dTuple, (String)"Failed to write/read tuple");
    }

    @Test
    public void testWideWritable() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(131);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 3 != 0) continue;
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertEquals((Object)sTuple, (Object)dTuple, (String)"Failed to write/read tuple");
        Assertions.assertEquals((int)-1, (int)in.read(), (String)"All tuple data has not been read from the stream");
    }

    @Test
    public void testWideWritable2() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(71);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertEquals((Object)sTuple, (Object)dTuple, (String)"Failed to write/read tuple");
        Assertions.assertEquals((int)-1, (int)in.read(), (String)"All tuple data has not been read from the stream");
    }

    @Test
    public void testSparseWideWritable() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(131);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 65 != 0) continue;
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertEquals((Object)sTuple, (Object)dTuple, (String)"Failed to write/read tuple");
        Assertions.assertEquals((int)-1, (int)in.read(), (String)"All tuple data has not been read from the stream");
    }

    @Test
    public void testWideTuple() throws Exception {
        Text emptyText = new Text("Should be empty");
        Object[] values = new Writable[64];
        Arrays.fill(values, emptyText);
        values[42] = new Text("Number 42");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(42);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 42) {
                Assertions.assertTrue((boolean)has);
                continue;
            }
            Assertions.assertFalse((boolean)has, (String)("Tuple position is incorrectly labelled as set: " + pos));
        }
    }

    @Test
    public void testWideTuple2() throws Exception {
        Text emptyText = new Text("Should be empty");
        Object[] values = new Writable[64];
        Arrays.fill(values, emptyText);
        values[9] = new Text("Number 9");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(9);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 9) {
                Assertions.assertTrue((boolean)has);
                continue;
            }
            Assertions.assertFalse((boolean)has, (String)("Tuple position is incorrectly labelled as set: " + pos));
        }
    }

    @Test
    public void testWideTupleBoundary() throws Exception {
        Text emptyText = new Text("Should not be set written");
        Object[] values = new Writable[65];
        Arrays.fill(values, emptyText);
        values[64] = new Text("Should be the only value set written");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(64);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 64) {
                Assertions.assertTrue((boolean)has);
                continue;
            }
            Assertions.assertFalse((boolean)has, (String)("Tuple position is incorrectly labelled as set: " + pos));
        }
    }

    @Test
    public void testPreVersion21Compatibility() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(64);
        PreVersion21TupleWritable oldTuple = new PreVersion21TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 3 != 0) continue;
            oldTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        oldTuple.write(new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertTrue((boolean)oldTuple.isCompatible(dTuple), (String)"Tuple writable is unable to read pre-0.21 versions of TupleWritable");
        Assertions.assertEquals((int)-1, (int)in.read(), (String)"All tuple data has not been read from the stream");
    }

    @Test
    public void testPreVersion21CompatibilityEmptyTuple() throws Exception {
        Writable[] manyWrits = new Writable[]{};
        PreVersion21TupleWritable oldTuple = new PreVersion21TupleWritable(manyWrits);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        oldTuple.write(new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        Assertions.assertTrue((boolean)oldTuple.isCompatible(dTuple), (String)"Tuple writable is unable to read pre-0.21 versions of TupleWritable");
        Assertions.assertEquals((int)-1, (int)in.read(), (String)"All tuple data has not been read from the stream");
    }

    private static class PreVersion21TupleWritable {
        private Writable[] values;
        private long written = 0L;

        private PreVersion21TupleWritable(Writable[] vals) {
            this.values = vals;
        }

        private void setWritten(int i) {
            this.written |= 1L << i;
        }

        private boolean has(int i) {
            return 0L != (1L << i & this.written);
        }

        private void write(DataOutput out) throws IOException {
            int i;
            WritableUtils.writeVInt((DataOutput)out, (int)this.values.length);
            WritableUtils.writeVLong((DataOutput)out, (long)this.written);
            for (i = 0; i < this.values.length; ++i) {
                Text.writeString((DataOutput)out, (String)this.values[i].getClass().getName());
            }
            for (i = 0; i < this.values.length; ++i) {
                if (!this.has(i)) continue;
                this.values[i].write(out);
            }
        }

        public int size() {
            return this.values.length;
        }

        public boolean isCompatible(TupleWritable that) {
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.has(i) != that.has(i)) {
                    return false;
                }
                if (!this.has(i) || this.values[i].equals(that.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

