/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTaskStatus {
    @Test
    public void testMapTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(true);
    }

    @Test
    public void testReduceTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(false);
    }

    private void checkTaskStatues(boolean isMap) {
        Object status = null;
        status = isMap ? new MapTaskStatus() : new ReduceTaskStatus();
        long currentTime = System.currentTimeMillis();
        status.setFinishTime(currentTime);
        Assertions.assertEquals((long)0L, (long)status.getFinishTime(), (String)"Finish time of the task status set without start time");
        status.setStartTime(currentTime);
        Assertions.assertEquals((long)currentTime, (long)status.getStartTime(), (String)"Start time of the task status not set correctly.");
        long wrongTime = -1L;
        status.setStartTime(wrongTime);
        Assertions.assertEquals((long)currentTime, (long)status.getStartTime(), (String)"Start time of the task status is set to wrong negative value");
        status.setFinishTime(wrongTime);
        Assertions.assertEquals((long)0L, (long)status.getFinishTime(), (String)"Finish time of task status is set to wrong negative value");
        status.setFinishTime(currentTime);
        Assertions.assertEquals((long)currentTime, (long)status.getFinishTime(), (String)"Finish time of the task status not set correctly.");
        TaskStatus ts = (TaskStatus)status.clone();
        ts.setDiagnosticInfo(null);
        ts.setDiagnosticInfo("");
        ts.setStateString(null);
        ts.setStateString("");
        ((TaskStatus)status.clone()).statusUpdate(ts);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, null, null);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, "", null);
        ((TaskStatus)status.clone()).statusUpdate(null, 0.0f, "", null, 1L);
    }

    @Test
    public void testTaskDiagnosticsAndStateString() {
        String test = "hi";
        int maxSize = 16;
        TaskStatus status = new TaskStatus(null, 0.0f, 0, null, test, test, null, null, null){

            protected int getMaxStringSize() {
                return 16;
            }

            public void addFetchFailedMap(TaskAttemptID mapTaskId) {
            }

            public boolean getIsMap() {
                return false;
            }
        };
        Assertions.assertEquals((Object)status.getDiagnosticInfo(), (Object)test, (String)"Small diagnostic info test failed");
        Assertions.assertEquals((Object)status.getStateString(), (Object)test, (String)"Small state string test failed");
        String newDInfo = test.concat(test);
        status.setDiagnosticInfo(test);
        status.setStateString(newDInfo);
        Assertions.assertEquals((Object)newDInfo, (Object)status.getDiagnosticInfo(), (String)"Small diagnostic info append failed");
        Assertions.assertEquals((Object)newDInfo, (Object)status.getStateString(), (String)"Small state-string append failed");
        TaskStatus newStatus = (TaskStatus)status.clone();
        String newSInfo = "hi1";
        newStatus.setStateString(newSInfo);
        status.statusUpdate(newStatus);
        newDInfo = newDInfo.concat(newStatus.getDiagnosticInfo());
        Assertions.assertEquals((Object)newDInfo, (Object)status.getDiagnosticInfo(), (String)"Status-update on diagnostic-info failed");
        Assertions.assertEquals((Object)newSInfo, (Object)status.getStateString(), (String)"Status-update on state-string failed");
        newSInfo = "hi2";
        status.statusUpdate(0.0f, newSInfo, null);
        Assertions.assertEquals((Object)newSInfo, (Object)status.getStateString(), (String)"Status-update on state-string failed");
        newSInfo = "hi3";
        status.statusUpdate(null, 0.0f, newSInfo, null, 0L);
        Assertions.assertEquals((Object)newSInfo, (Object)status.getStateString(), (String)"Status-update on state-string failed");
        String large = "hihihihihihihihihihi";
        status.setDiagnosticInfo(large);
        status.setStateString(large);
        Assertions.assertEquals((int)16, (int)status.getDiagnosticInfo().length(), (String)"Large diagnostic info append test failed");
        Assertions.assertEquals((int)16, (int)status.getStateString().length(), (String)"Large state-string append test failed");
        newStatus.setDiagnosticInfo(large + "0");
        newStatus.setStateString(large + "1");
        status.statusUpdate(newStatus);
        Assertions.assertEquals((int)16, (int)status.getDiagnosticInfo().length(), (String)"Status-update on diagnostic info failed");
        Assertions.assertEquals((int)16, (int)status.getStateString().length(), (String)"Status-update on state-string failed");
        status.statusUpdate(0.0f, large + "2", null);
        Assertions.assertEquals((int)16, (int)status.getStateString().length(), (String)"Status-update on state-string failed");
        status.statusUpdate(null, 0.0f, large + "3", null, 0L);
        Assertions.assertEquals((int)16, (int)status.getStateString().length(), (String)"Status-update on state-string failed");
        status = new TaskStatus(null, 0.0f, 0, null, large, large, null, null, null){

            protected int getMaxStringSize() {
                return 16;
            }

            public void addFetchFailedMap(TaskAttemptID mapTaskId) {
            }

            public boolean getIsMap() {
                return false;
            }
        };
        Assertions.assertEquals((int)16, (int)status.getDiagnosticInfo().length(), (String)"Large diagnostic info test failed");
        Assertions.assertEquals((int)16, (int)status.getStateString().length(), (String)"Large state-string test failed");
    }
}

