/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Map;
import org.apache.hadoop.mapred.StatisticsCollector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatisticsCollector {
    @Test
    public void testMovingWindow() throws Exception {
        StatisticsCollector collector = new StatisticsCollector(1);
        StatisticsCollector.TimeWindow window = new StatisticsCollector.TimeWindow("test", 6, 2);
        StatisticsCollector.TimeWindow sincStart = StatisticsCollector.SINCE_START;
        StatisticsCollector.TimeWindow[] windows = new StatisticsCollector.TimeWindow[]{sincStart, window};
        StatisticsCollector.Stat stat = collector.createStat("m1", windows);
        stat.inc(3);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(3);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)26, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)26, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        stat.inc(10);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)46, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)46, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(10);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)46, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)56, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(12);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)62, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)68, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(13);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)62, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)81, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        stat.inc(14);
        collector.update();
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)95, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        Map updaters = collector.getUpdaters();
        Assertions.assertThat((int)updaters.size()).isEqualTo(2);
        Map ststistics = collector.getStatistics();
        org.junit.jupiter.api.Assertions.assertNotNull(ststistics.get("m1"));
        StatisticsCollector.Stat newStat = collector.createStat("m2");
        Assertions.assertThat((String)newStat.name).isEqualTo((Object)"m2");
        StatisticsCollector.Stat st = collector.removeStat("m1");
        Assertions.assertThat((String)st.name).isEqualTo((Object)"m1");
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)95, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
        st = collector.removeStat("m1");
        org.junit.jupiter.api.Assertions.assertNull((Object)st);
        collector.start();
        Thread.sleep(2500L);
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(window)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((int)95, (int)((StatisticsCollector.Stat.TimeStat)stat.getValues().get(sincStart)).getValue());
    }
}

