/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobQueueClient;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestNetworkedJob {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
    private static Path inFile = new Path(testDir, "in");
    private static Path outDir = new Path(testDir, "out");

    @Test
    @Timeout(value=5L)
    public void testGetNullCounters() throws Exception {
        Job mockJob = (Job)Mockito.mock(Job.class);
        JobClient.NetworkedJob underTest = new JobClient.NetworkedJob(mockJob);
        Mockito.when((Object)mockJob.getCounters()).thenReturn(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)underTest.getCounters());
        ((Job)Mockito.verify((Object)mockJob)).getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=500L)
    public void testGetJobStatus() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            org.junit.jupiter.api.Assertions.assertEquals((Object)jobId, (Object)client.getJob(jobId).getJobStatus().getJobID(), (String)"Expected matching JobIDs");
            org.junit.jupiter.api.Assertions.assertEquals((long)rj.getJobStatus().getStartTime(), (long)client.getJob(jobId).getJobStatus().getStartTime(), (String)"Expected matching startTimes");
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=500L)
    public void testNetworkedJob() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            JobClient.NetworkedJob runningJob = (JobClient.NetworkedJob)client.getJob(jobId);
            runningJob.setJobPriority(JobPriority.HIGH.name());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)runningJob.getConfiguration().toString().endsWith("0001/job.xml"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)jobId, (Object)runningJob.getID());
            org.junit.jupiter.api.Assertions.assertEquals((Object)jobId.toString(), (Object)runningJob.getJobID());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"N/A", (Object)runningJob.getJobName());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)runningJob.getJobFile().endsWith(".staging/" + runningJob.getJobID() + "/job.xml"));
            org.junit.jupiter.api.Assertions.assertTrue((runningJob.getTrackingURL().length() > 0 ? 1 : 0) != 0);
            Assertions.assertThat((float)runningJob.mapProgress()).isEqualTo(0.0f);
            Assertions.assertThat((float)runningJob.reduceProgress()).isEqualTo(0.0f);
            Assertions.assertThat((float)runningJob.cleanupProgress()).isEqualTo(0.0f);
            Assertions.assertThat((float)runningJob.setupProgress()).isEqualTo(0.0f);
            TaskCompletionEvent[] tce = runningJob.getTaskCompletionEvents(0);
            org.junit.jupiter.api.Assertions.assertEquals((int)tce.length, (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)runningJob.getHistoryUrl());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)runningJob.isRetired());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)runningJob.getFailureInfo());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"N/A", (Object)runningJob.getJobStatus().getJobName());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.getMapTaskReports(jobId).length);
            try {
                client.getSetupTaskReports(jobId);
            }
            catch (YarnRuntimeException e) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"Unrecognized task type: JOB_SETUP", (Object)e.getMessage());
            }
            try {
                client.getCleanupTaskReports(jobId);
            }
            catch (YarnRuntimeException e) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"Unrecognized task type: JOB_CLEANUP", (Object)e.getMessage());
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.getReduceTaskReports(jobId).length);
            ClusterStatus status = client.getClusterStatus(true);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)status.getActiveTrackerNames().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)status.getBlacklistedTrackers());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)status.getBlacklistedTrackerNames().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)status.getBlackListedTrackersInfo().size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Cluster.JobTrackerStatus.RUNNING, (Object)status.getJobTrackerStatus());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)status.getMapTasks());
            org.junit.jupiter.api.Assertions.assertEquals((int)20, (int)status.getMaxMapTasks());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)status.getMaxReduceTasks());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)status.getNumExcludedNodes());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)status.getReduceTasks());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)status.getTaskTrackers());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)status.getTTExpiryInterval());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Cluster.JobTrackerStatus.RUNNING, (Object)status.getJobTrackerStatus());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)status.getGraylistedTrackers());
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
            status.write((DataOutput)new DataOutputStream(dataOut));
            ClusterStatus status2 = new ClusterStatus();
            status2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(dataOut.toByteArray())));
            org.junit.jupiter.api.Assertions.assertEquals((Object)status.getActiveTrackerNames(), (Object)status2.getActiveTrackerNames());
            org.junit.jupiter.api.Assertions.assertEquals((Object)status.getBlackListedTrackersInfo(), (Object)status2.getBlackListedTrackersInfo());
            org.junit.jupiter.api.Assertions.assertEquals((int)status.getMapTasks(), (int)status2.getMapTasks());
            JobClient.setTaskOutputFilter((JobConf)job, (JobClient.TaskStatusFilter)JobClient.TaskStatusFilter.ALL);
            org.junit.jupiter.api.Assertions.assertEquals((Object)JobClient.TaskStatusFilter.ALL, (Object)JobClient.getTaskOutputFilter((JobConf)job));
            org.junit.jupiter.api.Assertions.assertEquals((int)20, (int)client.getDefaultMaps());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)client.getDefaultReduces());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"jobSubmitDir", (Object)client.getSystemDir().getName());
            JobQueueInfo[] rootQueueInfo = client.getRootQueues();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)rootQueueInfo.length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)rootQueueInfo[0].getQueueName());
            JobQueueInfo[] qinfo = client.getQueues();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)qinfo.length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)qinfo[0].getQueueName());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.getChildQueues("default").length);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)client.getJobsFromQueue("default").length);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)client.getJobsFromQueue("default")[0].getJobFile().endsWith("/job.xml"));
            JobQueueInfo qi = client.getQueueInfo("default");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)qi.getQueueName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"running", (Object)qi.getQueueState());
            QueueAclsInfo[] aai = client.getQueueAclsForCurrentUser();
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)aai.length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"root", (Object)aai[0].getQueueName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"root.default", (Object)aai[1].getQueueName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)jobId, (Object)client.getJob(jobId).getJobStatus().getJobID(), (String)"Expected matching JobIDs");
            org.junit.jupiter.api.Assertions.assertEquals((long)rj.getJobStatus().getStartTime(), (long)client.getJob(jobId).getJobStatus().getStartTime(), (String)"Expected matching startTimes");
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    @Test
    @Timeout(value=5L)
    public void testBlackListInfo() throws IOException {
        ClusterStatus.BlackListInfo info = new ClusterStatus.BlackListInfo();
        info.setBlackListReport("blackListInfo");
        info.setReasonForBlackListing("reasonForBlackListing");
        info.setTrackerName("trackerName");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        info.write((DataOutput)out);
        ClusterStatus.BlackListInfo info2 = new ClusterStatus.BlackListInfo();
        info2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteOut.toByteArray())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)info, (Object)info2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)info.toString(), (Object)info2.toString());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"trackerName", (Object)info2.getTrackerName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"reasonForBlackListing", (Object)info2.getReasonForBlackListing());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"blackListInfo", (Object)info2.getBlackListReport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=500L)
    public void testJobQueueClient() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        PrintStream oldOut = System.out;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            client.submitJob(job);
            JobQueueClient jobClient = new JobQueueClient(job);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg = new String[]{"-list"};
            jobClient.run(arg);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg1 = new String[]{"-showacls"};
            jobClient.run(arg1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue acls for user :"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("root  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("default  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg2 = new String[]{"-info", "default"};
            jobClient.run(arg2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg3 = new String[]{"-info", "default", "-showJobs"};
            jobClient.run(arg3);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)bytes.toString().contains("job_1"));
            String[] arg4 = new String[]{};
            jobClient.run(arg4);
        }
        finally {
            System.setOut(oldOut);
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    private MiniMRClientCluster createMiniClusterWithCapacityScheduler() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        conf.set("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", "99");
        return MiniMRClientClusterFactory.create(this.getClass(), 2, conf);
    }
}

