/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.util.Shell;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMiniMRChildTask {
    private static final Logger LOG = LoggerFactory.getLogger(TestMiniMRChildTask.class);
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";
    private static MiniMRYarnCluster mr;
    private static MiniDFSCluster dfs;
    private static FileSystem fileSys;
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    private void configure(JobConf conf, Path inDir, Path outDir, String input, Class<? extends Mapper> map, Class<? extends Reducer> reduce) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("testmap");
        conf.setMapperClass(map);
        conf.setReducerClass(reduce);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
    }

    private static void checkEnv(String envName, String expValue, String mode) {
        String envValue = System.getenv(envName);
        if ("append".equals(mode)) {
            if (envValue == null || !envValue.contains(File.pathSeparator)) {
                throw new RuntimeException("Missing env variable");
            }
            String[] parts = envValue.trim().split(File.pathSeparator);
            if (!parts[parts.length - 1].equals(expValue)) {
                throw new RuntimeException("Wrong env variable in append mode");
            }
        } else if (envValue == null || !envValue.trim().equals(expValue)) {
            throw new RuntimeException("Wrong env variable in noappend mode");
        }
    }

    @BeforeAll
    public static void setup() throws IOException {
        dfs = new MiniDFSCluster.Builder(conf).build();
        fileSys = dfs.getFileSystem();
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mr == null) {
            mr = new MiniMRYarnCluster(TestMiniMRChildTask.class.getName());
            Configuration conf = new Configuration();
            mr.init(conf);
            mr.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterAll
    public static void tearDown() {
        try {
            if (fileSys != null) {
                fileSys.close();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.stop();
                mr = null;
            }
        }
        catch (IOException ioe) {
            LOG.info("IO exception in closing file system)");
            ioe.printStackTrace();
        }
    }

    @Test
    public void testTaskEnv() {
        try {
            JobConf conf = new JobConf(mr.getConfig());
            String baseDir = System.getProperty("test.build.data", "build/test/data");
            Path inDir = new Path(baseDir + "/testing/wc/input1");
            Path outDir = new Path(baseDir + "/testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, false);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)"Exception in testing child env");
            TestMiniMRChildTask.tearDown();
        }
    }

    @Test
    public void testTaskOldEnv() {
        try {
            JobConf conf = new JobConf(mr.getConfig());
            String baseDir = System.getProperty("test.build.data", "build/test/data");
            Path inDir = new Path(baseDir + "/testing/wc/input1");
            Path outDir = new Path(baseDir + "/testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, true);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)"Exception in testing child env");
            TestMiniMRChildTask.tearDown();
        }
    }

    private void runTestTaskEnv(JobConf config, Path inDir, Path outDir, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        String input = "The input";
        this.configure(config, inDir, outDir, input, EnvCheckMapper.class, EnvCheckReducer.class);
        String mapTaskEnvKey = "mapreduce.map.env";
        String reduceTaskEnvKey = "mapreduce.map.env";
        String mapTaskJavaOptsKey = "mapreduce.map.java.opts";
        String reduceTaskJavaOptsKey = "mapreduce.reduce.java.opts";
        String mapTaskJavaOpts = "-Xmx200m";
        String reduceTaskJavaOpts = REDUCE_OPTS_VAL;
        config.setBoolean(OLD_CONFIGS, oldConfigs);
        if (oldConfigs) {
            reduceTaskEnvKey = "mapred.child.env";
            mapTaskEnvKey = "mapred.child.env";
            reduceTaskJavaOptsKey = "mapred.child.java.opts";
            mapTaskJavaOptsKey = "mapred.child.java.opts";
            reduceTaskJavaOpts = "-Xmx200m";
            mapTaskJavaOpts = "-Xmx200m";
        }
        config.set(mapTaskEnvKey, Shell.WINDOWS ? "MY_PATH=/tmp,LANG=en_us_8859_1,NEW_PATH=%MY_PATH%;/tmp" : "MY_PATH=/tmp,LANG=en_us_8859_1,NEW_PATH=$NEW_PATH:/tmp");
        config.set(reduceTaskEnvKey, Shell.WINDOWS ? "MY_PATH=/tmp,LANG=en_us_8859_1,NEW_PATH=%MY_PATH%;/tmp" : "MY_PATH=/tmp,LANG=en_us_8859_1,NEW_PATH=$NEW_PATH:/tmp");
        config.set(mapTaskJavaOptsKey, mapTaskJavaOpts);
        config.set(reduceTaskJavaOptsKey, reduceTaskJavaOpts);
        Job job = Job.getInstance((Configuration)config);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(TestMiniMRChildTask.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        boolean succeeded = job.waitForCompletion(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)succeeded, (String)"The environment checker job failed.");
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = localFs.makeQualified(new Path("target", TestMiniMRChildTask.class.getName() + "-tmpDir"));
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }

    private static class EnvCheckReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        private EnvCheckReducer() {
        }

        public void configure(JobConf job) {
            boolean oldConfigs = job.getBoolean(TestMiniMRChildTask.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = job.get("mapred.child.java.opts");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)javaOpts, (String)"mapred.child.java.opts is null!");
                ((AbstractStringAssert)Assertions.assertThat((String)javaOpts).withFailMessage("mapred.child.java.opts has value of: " + javaOpts, new Object[0])).isEqualTo((Object)"-Xmx200m");
            } else {
                String reduceJavaOpts = job.get("mapreduce.reduce.java.opts");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)reduceJavaOpts, (String)"mapreduce.reduce.java.opts is null!");
                ((AbstractStringAssert)Assertions.assertThat((String)reduceJavaOpts).withFailMessage("mapreduce.reduce.java.opts has value of: " + reduceJavaOpts, new Object[0])).isEqualTo((Object)TestMiniMRChildTask.REDUCE_OPTS_VAL);
            }
            TestMiniMRChildTask.checkEnv("LANG", "en_us_8859_1", "noappend");
            TestMiniMRChildTask.checkEnv("MY_PATH", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("NEW_PATH", File.pathSeparator + "/tmp", "noappend");
        }

        public void reduce(WritableComparable key, Iterator<Writable> values, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
        }
    }

    private static class EnvCheckMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        private EnvCheckMapper() {
        }

        public void configure(JobConf job) {
            boolean oldConfigs = job.getBoolean(TestMiniMRChildTask.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = job.get("mapred.child.java.opts");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)javaOpts, (String)"mapred.child.java.opts is null!");
                ((AbstractStringAssert)Assertions.assertThat((String)javaOpts).withFailMessage("mapred.child.java.opts has value of: " + javaOpts, new Object[0])).isEqualTo((Object)"-Xmx200m");
            } else {
                String mapJavaOpts = job.get("mapreduce.map.java.opts");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)mapJavaOpts, (String)"mapreduce.map.java.opts is null!");
                org.junit.jupiter.api.Assertions.assertEquals((Object)mapJavaOpts, (Object)"-Xmx200m", (String)("mapreduce.map.java.opts has value of: " + mapJavaOpts));
            }
            TestMiniMRChildTask.checkEnv("LANG", "en_us_8859_1", "noappend");
            TestMiniMRChildTask.checkEnv("MY_PATH", "/tmp", "noappend");
            TestMiniMRChildTask.checkEnv("NEW_PATH", File.pathSeparator + "/tmp", "noappend");
            String jobLocalDir = job.get("mapreduce.job.local.dir");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)jobLocalDir, (String)"mapreduce.job.local.dir is null");
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        Path tmpDir;

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            if (!localFs.exists(this.tmpDir)) {
                org.junit.jupiter.api.Assertions.fail((String)("Temp directory " + this.tmpDir + " doesnt exist."));
            }
            File tmpFile = File.createTempFile("test", ".tmp");
        }

        public void configure(JobConf job) {
            this.tmpDir = new Path(System.getProperty("java.io.tmpdir"));
            try {
                localFs = (FileSystem)FileSystem.getLocal((Configuration)job);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                org.junit.jupiter.api.Assertions.fail((String)"IOException in getting localFS");
            }
        }
    }
}

