/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMapOutputType {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestMapOutputType-mapred");
    JobConf conf = new JobConf(TestMapOutputType.class);
    JobClient jc;

    @BeforeEach
    public void configure() throws Exception {
        Path testdir = new Path(TEST_DIR.getAbsolutePath());
        Path inDir = new Path(testdir, "in");
        Path outDir = new Path(testdir, "out");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(testdir, true);
        this.conf.setInt("mapreduce.task.io.sort.mb", 1);
        this.conf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outDir);
        this.conf.setMapperClass(TextGen.class);
        this.conf.setReducerClass(TextReduce.class);
        this.conf.setOutputKeyClass(Text.class);
        this.conf.setOutputValueClass(Text.class);
        this.conf.set("mapreduce.framework.name", "local");
        this.conf.setOutputFormat(SequenceFileOutputFormat.class);
        if (!fs.mkdirs(testdir)) {
            throw new IOException("Mkdirs failed to create " + testdir.toString());
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        Path inFile = new Path(inDir, "part0");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)inFile, Text.class, Text.class);
        writer.append((Writable)new Text("rec: 1"), (Writable)new Text("Hello"));
        writer.close();
        this.jc = new JobClient(this.conf);
    }

    @AfterEach
    public void cleanup() {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test
    public void testKeyMismatch() throws Exception {
        this.conf.setMapOutputKeyClass(IntWritable.class);
        this.conf.setMapOutputValueClass(IntWritable.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (r_job.isSuccessful()) {
            Assertions.fail((String)"Oops! The job was supposed to break due to an exception");
        }
    }

    @Test
    public void testValueMismatch() throws Exception {
        this.conf.setMapOutputKeyClass(Text.class);
        this.conf.setMapOutputValueClass(IntWritable.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (r_job.isSuccessful()) {
            Assertions.fail((String)"Oops! The job was supposed to break due to an exception");
        }
    }

    @Test
    public void testNoMismatch() throws Exception {
        this.conf.setMapOutputKeyClass(Text.class);
        this.conf.setMapOutputValueClass(Text.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            Assertions.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    static class TextReduce
    implements Reducer<Text, Text, Text, Text> {
        TextReduce() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
            out.collect((Object)new Text("Test"), (Object)new Text("Me"));
        }

        public void close() {
        }
    }

    static class TextGen
    implements Mapper<WritableComparable, Writable, Text, Text> {
        TextGen() {
        }

        public void configure(JobConf job) {
        }

        public void map(WritableComparable key, Writable val, OutputCollector<Text, Text> out, Reporter reporter) throws IOException {
            out.collect((Object)new Text("Hello"), (Object)new Text("World"));
        }

        public void close() {
        }
    }
}

