/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMROpportunisticMaps {
    private static final Path INPUT_DIR = new Path("/test/input");
    private static final Path OUTPUT = new Path("/test/output");

    @Test
    public void testAllOpportunisticMaps() throws Exception {
        this.doTest(4, 1, 1, 4);
    }

    @Test
    public void testHalfOpportunisticMaps() throws Exception {
        this.doTest(4, 1, 1, 2);
    }

    public void doTest(int numMappers, int numReducers, int numNodes, int percent) throws Exception {
        this.doTest(numMappers, numReducers, numNodes, 1000, percent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(int numMappers, int numReducers, int numNodes, int numLines, int percent) throws Exception {
        MiniDFSCluster dfsCluster = null;
        MiniMRClientCluster mrCluster = null;
        DistributedFileSystem fileSystem = null;
        try {
            Configuration conf = MRJobConfUtil.initEncryptedIntermediateConfigsForTesting(null);
            conf.setBoolean("yarn.nodemanager.amrmproxy.enabled", true);
            conf.setBoolean("yarn.resourcemanager.opportunistic-container-allocation.enabled", true);
            conf.setBoolean("yarn.nodemanager.distributed-scheduling.enabled", true);
            conf.setInt("yarn.nodemanager.opportunistic-containers-max-queue-length", 10);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(numNodes).build();
            fileSystem = dfsCluster.getFileSystem();
            mrCluster = MiniMRClientClusterFactory.create(this.getClass(), numNodes, conf);
            this.createInput((FileSystem)fileSystem, numMappers, numLines);
            this.runMergeTest(new JobConf(conf), (FileSystem)fileSystem, numMappers, numReducers, numLines, percent);
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
            if (mrCluster != null) {
                mrCluster.stop();
            }
        }
    }

    private void createInput(FileSystem fs, int numMappers, int numLines) throws Exception {
        fs.delete(INPUT_DIR, true);
        for (int i = 0; i < numMappers; ++i) {
            FSDataOutputStream os = fs.create(new Path(INPUT_DIR, "input_" + i + ".txt"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os);
            for (int j = 0; j < numLines; ++j) {
                int k = j + 1;
                String formattedNumber = String.format("%09d", k);
                writer.write(formattedNumber + " " + formattedNumber + "\n");
            }
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMergeTest(JobConf job, FileSystem fileSystem, int numMappers, int numReducers, int numLines, int percent) throws Exception {
        fileSystem.delete(OUTPUT, true);
        job.setJobName("Test");
        JobClient client = new JobClient(job);
        RunningJob submittedJob = null;
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)OUTPUT);
        job.set("mapreduce.output.textoutputformat.separator", " ");
        job.setInputFormat(TextInputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(MyMapper.class);
        job.setPartitionerClass(MyPartitioner.class);
        job.setOutputFormat(TextOutputFormat.class);
        job.setNumReduceTasks(numReducers);
        job.setInt("mapreduce.job.num-opportunistic-maps-percent", percent);
        job.setInt("mapreduce.map.maxattempts", 1);
        job.setInt("mapreduce.reduce.maxattempts", 1);
        job.setInt("mapred.test.num_lines", numLines);
        try {
            submittedJob = client.submitJob(job);
            try {
                if (!client.monitorAndPrintJob(job, submittedJob)) {
                    throw new IOException("Job failed!");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException ioe) {
            System.err.println("Job failed with: " + ioe);
        }
        finally {
            this.verifyOutput(fileSystem, numMappers, numLines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOutput(FileSystem fileSystem, int numMappers, int numLines) throws Exception {
        Path[] fileList;
        FSDataInputStream dis = null;
        long numValidRecords = 0L;
        long numInvalidRecords = 0L;
        String prevKeyValue = "000000000";
        for (Path outFile : fileList = FileUtil.stat2Paths((FileStatus[])fileSystem.listStatus(OUTPUT, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            try {
                String record;
                dis = fileSystem.open(outFile);
                while ((record = dis.readLine()) != null) {
                    int blankPos = record.indexOf(" ");
                    String keyString = record.substring(0, blankPos);
                    String valueString = record.substring(blankPos + 1);
                    if (keyString.compareTo(prevKeyValue) >= 0 && keyString.equals(valueString)) {
                        prevKeyValue = keyString;
                        ++numValidRecords;
                        continue;
                    }
                    ++numInvalidRecords;
                }
            }
            finally {
                if (dis != null) {
                    dis.close();
                    dis = null;
                }
            }
        }
        Assertions.assertEquals((long)(numMappers * numLines), (long)numValidRecords);
        Assertions.assertEquals((long)0L, (long)numInvalidRecords);
    }

    static class MyPartitioner
    implements Partitioner<Text, Text> {
        private JobConf job;

        public void configure(JobConf jobConf) {
            this.job = jobConf;
        }

        public int getPartition(Text key, Text value, int numPartitions) {
            int keyValue = 0;
            try {
                keyValue = Integer.parseInt(key.toString());
            }
            catch (NumberFormatException nfe) {
                keyValue = 0;
            }
            int partitionNumber = numPartitions * Math.max(0, keyValue - 1) / this.job.getInt("mapred.test.num_lines", 10000);
            return partitionNumber;
        }
    }

    public static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, Text> {
        private Text keyText = new Text();
        private Text valueText = new Text();

        public void map(LongWritable key, Text value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            String record = value.toString();
            int blankPos = record.indexOf(" ");
            this.keyText.set(record.substring(0, blankPos));
            this.valueText.set(record.substring(blankPos + 1));
            output.collect((Object)this.keyText, (Object)this.valueText);
        }

        public void close() throws IOException {
        }
    }
}

