/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ClassUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class TestMRCJCJobConf {
    private static final String JAR_RELATIVE_PATH = "build/test/mapred/testjar/testjob.jar";
    private static final String CLASSNAME = "testjar.ClassWordCount";
    private static String TEST_DIR_WITH_SPECIAL_CHARS = System.getProperty("test.build.data", "/tmp") + File.separator + "test jobconf with + and spaces";

    @Test
    public void testFindContainingJar() throws Exception {
        this.testJarAtPath(JAR_RELATIVE_PATH);
    }

    @Test
    public void testFindContainingJarWithPlus() throws Exception {
        new File(TEST_DIR_WITH_SPECIAL_CHARS).mkdirs();
        Configuration conf = new Configuration();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        FileUtil.copy((FileSystem)localfs, (Path)new Path(JAR_RELATIVE_PATH), (FileSystem)localfs, (Path)new Path(TEST_DIR_WITH_SPECIAL_CHARS, "test.jar"), (boolean)false, (boolean)true, (Configuration)conf);
        this.testJarAtPath(TEST_DIR_WITH_SPECIAL_CHARS + File.separator + "test.jar");
    }

    private void testJarAtPath(String path) throws Exception {
        File jar = new File(path).getAbsoluteFile();
        Assertions.assertTrue((boolean)jar.exists());
        URL[] urls = new URL[]{jar.toURI().toURL()};
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> clazz = Class.forName(CLASSNAME, true, cl);
        Assertions.assertNotNull(clazz);
        String containingJar = ClassUtil.findContainingJar(clazz);
        Assertions.assertEquals((Object)jar.getAbsolutePath(), (Object)containingJar);
    }
}

