/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLineRecordReaderJobs {
    private static Path workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestTextInputFormat");
    private static Path inputDir = new Path(workDir, "input");
    private static Path outputDir = new Path(workDir, "output");

    public void createInputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(inputDir, "test.txt");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
        writer.write("abc\ndef\t\nghi\njkl");
        ((Writer)writer).close();
    }

    public String readOutputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(outputDir, "part-00000");
        return UtilsForTests.slurpHadoop(file, (FileSystem)localFs);
    }

    public void createAndRunJob(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf job = new JobConf(conf);
        job.setJarByClass(TestLineRecordReaderJobs.class);
        job.setMapperClass(IdentityMapper.class);
        job.setReducerClass(IdentityReducer.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        JobClient.runJob((JobConf)job);
    }

    @Test
    public void testCustomRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("textinputformat.record.delimiter", "\t\n");
        conf.setInt("mapreduce.job.maps", 1);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\ndef\n9\tghi\njkl\n";
        Assertions.assertEquals((Object)expected, (Object)this.readOutputFile(conf));
    }

    @Test
    public void testDefaultRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\n4\tdef\t\n9\tghi\n13\tjkl\n";
        Assertions.assertEquals((Object)expected, (Object)this.readOutputFile(conf));
    }
}

