/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueLineRecordReader;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKeyValueTextInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestKeyValueTextInputFormat.class);
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        Path file = new Path(workDir, "test.txt");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        LOG.info("seed = " + seed);
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug("creating; entries = " + length);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            format.configure(job);
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug("splitting: requesting = " + numSplits);
                InputSplit[] splits = format.getSplits(job, numSplits);
                LOG.debug("splitting: got =        " + splits.length);
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug("split[" + j + "]= " + splits[j]);
                    RecordReader reader = format.getRecordReader(splits[j], job, reporter);
                    Class<?> readerClass = reader.getClass();
                    Assertions.assertEquals(KeyValueLineRecordReader.class, readerClass, (String)"reader class is KeyValueLineRecordReader.");
                    Text key = (Text)reader.createKey();
                    Class<?> keyClass = key.getClass();
                    Text value = (Text)reader.createValue();
                    Class<?> valueClass = value.getClass();
                    Assertions.assertEquals(Text.class, keyClass, (String)"Key class is Text.");
                    Assertions.assertEquals(Text.class, valueClass, (String)"Value class is Text.");
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug("read " + v);
                            if (bits.get(v)) {
                                LOG.warn("conflict with " + v + " in split " + j + " at position " + reader.getPos());
                            }
                            Assertions.assertFalse((boolean)bits.get(v), (String)"Key in multiple partitions.");
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug("splits[" + j + "]=" + splits[j] + " count=" + count);
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assertions.assertEquals((int)length, (int)bits.cardinality(), (String)"Some keys in no partition.");
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)), (Configuration)defaultConf);
    }

    @Test
    public void testUTF8() throws Exception {
        try (LineReader in = null;){
            in = this.makeStream("abcd\u20acbdcd\u20ac");
            Text line = new Text();
            in.readLine(line);
            Assertions.assertEquals((Object)"abcd\u20acbdcd\u20ac", (Object)line.toString(), (String)"readLine changed utf8 characters");
            in = this.makeStream("abc\u200axyz");
            in.readLine(line);
            Assertions.assertEquals((Object)"abc\u200axyz", (Object)line.toString(), (String)"split on fake newline");
        }
    }

    @Test
    public void testNewLines() throws Exception {
        try (LineReader in = null;){
            in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
            Text out = new Text();
            in.readLine(out);
            Assertions.assertEquals((int)1, (int)out.getLength(), (String)"line1 length");
            in.readLine(out);
            Assertions.assertEquals((int)2, (int)out.getLength(), (String)"line2 length");
            in.readLine(out);
            Assertions.assertEquals((int)0, (int)out.getLength(), (String)"line3 length");
            in.readLine(out);
            Assertions.assertEquals((int)3, (int)out.getLength(), (String)"line4 length");
            in.readLine(out);
            Assertions.assertEquals((int)4, (int)out.getLength(), (String)"line5 length");
            in.readLine(out);
            Assertions.assertEquals((int)5, (int)out.getLength(), (String)"line5 length");
            Assertions.assertEquals((int)0, (int)in.readLine(out), (String)"end of file");
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        try (RecordReader reader = null;){
            reader = format.getRecordReader(split, job, voidReporter);
            Text key = (Text)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                result.add(value);
                value = (Text)reader.createValue();
            }
        }
        return result;
    }

    @Test
    public void testGzip() throws IOException {
        JobConf job = new JobConf();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        Assertions.assertEquals((int)2, (int)splits.length, (String)"compressed splits == 2");
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestKeyValueTextInputFormat.readSplit(format, splits[0], job);
        Assertions.assertEquals((int)6, (int)results.size(), (String)"splits[0] length");
        Assertions.assertEquals((Object)" dog", (Object)results.get(5).toString(), (String)"splits[0][5]");
        results = TestKeyValueTextInputFormat.readSplit(format, splits[1], job);
        Assertions.assertEquals((int)2, (int)results.size(), (String)"splits[1] length");
        Assertions.assertEquals((Object)"this is a test", (Object)results.get(0).toString(), (String)"splits[1][0]");
        Assertions.assertEquals((Object)"of gzip", (Object)results.get(1).toString(), (String)"splits[1][1]");
    }

    public static void main(String[] args) throws Exception {
        new TestKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
        voidReporter = Reporter.NULL;
    }
}

