/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestJobCounters {
    private static Path IN_DIR = null;
    private static Path OUT_DIR = null;
    private static Path testdir = null;
    private static Path[] inFiles = new Path[5];

    private void validateFileCounters(org.apache.hadoop.mapred.Counters counter, long fileBytesRead, long fileBytesWritten, long mapOutputBytes, long mapOutputMaterializedBytes) {
        Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)FileInputFormatCounter.BYTES_READ)).getValue() != 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)fileBytesRead, (long)((Counters.Counter)counter.findCounter((Enum)FileInputFormatCounter.BYTES_READ)).getValue());
        Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN)).getValue() != 0L ? 1 : 0) != 0);
        if (mapOutputBytes >= 0L) {
            Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES)).getValue() != 0L ? 1 : 0) != 0);
        }
        if (mapOutputMaterializedBytes >= 0L) {
            Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES)).getValue() != 0L ? 1 : 0) != 0);
        }
    }

    private void validateOldFileCounters(org.apache.hadoop.mapred.Counters counter, long fileBytesRead, long fileBytesWritten, long mapOutputBytes, long mapOutputMaterializedBytes) {
        Assertions.assertEquals((long)fileBytesRead, (long)((Counters.Counter)counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ)).getValue());
        Assertions.assertEquals((long)fileBytesRead, (long)((Counters.Counter)counter.findCounter((Enum)FileInputFormat.Counter.BYTES_READ)).getValue());
        Assertions.assertEquals((long)fileBytesWritten, (long)((Counters.Counter)counter.findCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN)).getValue());
        Assertions.assertEquals((long)fileBytesWritten, (long)((Counters.Counter)counter.findCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN)).getValue());
        if (mapOutputBytes >= 0L) {
            Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES)).getValue() != 0L ? 1 : 0) != 0);
        }
        if (mapOutputMaterializedBytes >= 0L) {
            Assertions.assertTrue((((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES)).getValue() != 0L ? 1 : 0) != 0);
        }
    }

    private void validateCounters(org.apache.hadoop.mapred.Counters counter, long spillRecCnt, long mapInputRecords, long mapOutputRecords) {
        Assertions.assertEquals((long)spillRecCnt, (long)((Counters.Counter)counter.findCounter((Enum)TaskCounter.SPILLED_RECORDS)).getCounter());
        Assertions.assertEquals((long)mapInputRecords, (long)((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_INPUT_RECORDS)).getCounter());
        Assertions.assertEquals((long)mapOutputRecords, (long)((Counters.Counter)counter.findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS)).getCounter());
    }

    private void removeWordsFile(Path inpFile, Configuration conf) throws IOException {
        FileSystem fs = inpFile.getFileSystem(conf);
        if (fs.exists(inpFile) && !fs.delete(inpFile, false)) {
            throw new IOException("Failed to delete " + inpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createWordsFile(Path inpFile, Configuration conf) throws IOException {
        FileSystem fs = inpFile.getFileSystem(conf);
        if (fs.exists(inpFile)) {
            return;
        }
        try (FSDataOutputStream out = fs.create(inpFile);){
            int REPLICAS = 5;
            int NUMLINES = 1024;
            int NUMWORDSPERLINE = 4;
            String WORD = "zymurgy";
            Formatter fmt = new Formatter(new StringBuilder());
            for (int i = 0; i < REPLICAS; ++i) {
                for (int j = 1; j <= NUMLINES * NUMWORDSPERLINE; j += NUMWORDSPERLINE) {
                    ((StringBuilder)fmt.out()).setLength(0);
                    for (int k = 0; k < NUMWORDSPERLINE; ++k) {
                        fmt.format("%s%04d ", "zymurgy", j + k);
                    }
                    ((StringBuilder)fmt.out()).append("\n");
                    out.writeBytes(fmt.toString());
                }
            }
        }
    }

    private static long getFileSize(Path path) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        long len = 0L;
        len += fs.getFileStatus(path).getLen();
        Path crcPath = new Path(path.getParent(), "." + path.getName() + ".crc");
        if (fs.exists(crcPath)) {
            len += fs.getFileStatus(crcPath).getLen();
        }
        return len;
    }

    @BeforeAll
    public static void initPaths() throws IOException {
        Configuration conf = new Configuration();
        Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
        testdir = new Path(TEST_ROOT_DIR, "spilledRecords.countertest");
        IN_DIR = new Path(testdir, "in");
        OUT_DIR = new Path(testdir, "out");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(testdir = new Path(TEST_ROOT_DIR, "spilledRecords.countertest")) && !fs.delete(testdir, true)) {
            throw new IOException("Could not delete " + testdir);
        }
        if (!fs.mkdirs(IN_DIR)) {
            throw new IOException("Mkdirs failed to create " + IN_DIR);
        }
        for (int i = 0; i < inFiles.length; ++i) {
            TestJobCounters.inFiles[i] = new Path(IN_DIR, "input5_2k_" + i);
        }
        TestJobCounters.createWordsFile(inFiles[0], conf);
        TestJobCounters.createWordsFile(inFiles[1], conf);
        TestJobCounters.createWordsFile(inFiles[2], conf);
    }

    @AfterAll
    public static void cleanup() throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = testdir.getFileSystem(conf);
        if (fs.exists(testdir)) {
            fs.delete(testdir, true);
        }
    }

    public static JobConf createConfiguration() throws IOException {
        JobConf baseConf = new JobConf(TestJobCounters.class);
        baseConf.setOutputKeyClass(Text.class);
        baseConf.setOutputValueClass(IntWritable.class);
        baseConf.setMapperClass(WordCount.MapClass.class);
        baseConf.setCombinerClass(WordCount.Reduce.class);
        baseConf.setReducerClass(WordCount.Reduce.class);
        baseConf.setNumReduceTasks(1);
        baseConf.setInt("mapreduce.task.io.sort.mb", 1);
        baseConf.set("mapreduce.map.sort.spill.percent", "0.50");
        baseConf.setInt("mapreduce.map.combine.minspills", 3);
        return baseConf;
    }

    public static Job createJob() throws IOException {
        Configuration conf = new Configuration();
        Job baseJob = Job.getInstance((Configuration)conf);
        baseJob.setOutputKeyClass(Text.class);
        baseJob.setOutputValueClass(IntWritable.class);
        baseJob.setMapperClass(NewMapTokenizer.class);
        baseJob.setCombinerClass(NewSummer.class);
        baseJob.setReducerClass(NewSummer.class);
        baseJob.setNumReduceTasks(1);
        baseJob.getConfiguration().setInt("mapreduce.task.io.sort.mb", 1);
        baseJob.getConfiguration().set("mapreduce.map.sort.spill.percent", "0.50");
        baseJob.getConfiguration().setInt("mapreduce.map.combine.minspills", 3);
        FileInputFormat.setMinInputSplitSize((Job)baseJob, (long)Long.MAX_VALUE);
        return baseJob;
    }

    @Test
    public void testOldCounterA() throws Exception {
        JobConf conf = TestJobCounters.createConfiguration();
        conf.setNumMapTasks(3);
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        this.removeWordsFile(inFiles[3], (Configuration)conf);
        this.removeWordsFile(inFiles[4], (Configuration)conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{IN_DIR});
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(OUT_DIR, "outputO0"));
        RunningJob myJob = JobClient.runJob((JobConf)conf);
        org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
        this.validateCounters(c1, 73728L, 15360L, 61440L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
        this.validateOldFileCounters(c1, inputSize, 61928L, 0L, 0L);
    }

    @Test
    public void testOldCounterB() throws Exception {
        JobConf conf = TestJobCounters.createConfiguration();
        TestJobCounters.createWordsFile(inFiles[3], (Configuration)conf);
        this.removeWordsFile(inFiles[4], (Configuration)conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        inputSize += TestJobCounters.getFileSize(inFiles[3]);
        conf.setNumMapTasks(4);
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{IN_DIR});
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(OUT_DIR, "outputO1"));
        RunningJob myJob = JobClient.runJob((JobConf)conf);
        org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
        this.validateCounters(c1, 98304L, 20480L, 81920L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
    }

    @Test
    public void testOldCounterC() throws Exception {
        JobConf conf = TestJobCounters.createConfiguration();
        TestJobCounters.createWordsFile(inFiles[3], (Configuration)conf);
        TestJobCounters.createWordsFile(inFiles[4], (Configuration)conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        inputSize += TestJobCounters.getFileSize(inFiles[3]);
        inputSize += TestJobCounters.getFileSize(inFiles[4]);
        conf.setNumMapTasks(4);
        conf.setInt("mapreduce.task.io.sort.factor", 3);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{IN_DIR});
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(OUT_DIR, "outputO2"));
        RunningJob myJob = JobClient.runJob((JobConf)conf);
        org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
        this.validateCounters(c1, 122880L, 25600L, 102400L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
    }

    @Test
    public void testOldCounterD() throws Exception {
        JobConf conf = TestJobCounters.createConfiguration();
        conf.setNumMapTasks(3);
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        conf.setNumReduceTasks(0);
        this.removeWordsFile(inFiles[3], (Configuration)conf);
        this.removeWordsFile(inFiles[4], (Configuration)conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{IN_DIR});
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(OUT_DIR, "outputO3"));
        RunningJob myJob = JobClient.runJob((JobConf)conf);
        org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
        this.validateCounters(c1, 0L, 15360L, 61440L);
        this.validateFileCounters(c1, inputSize, 0L, -1L, -1L);
    }

    @Test
    public void testNewCounterA() throws Exception {
        Job job = TestJobCounters.createJob();
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        this.removeWordsFile(inFiles[3], conf);
        this.removeWordsFile(inFiles[4], conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{IN_DIR});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUT_DIR, "outputN0"));
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        org.apache.hadoop.mapred.Counters c1 = org.apache.hadoop.mapred.Counters.downgrade((Counters)job.getCounters());
        this.validateCounters(c1, 73728L, 15360L, 61440L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
    }

    @Test
    public void testNewCounterB() throws Exception {
        Job job = TestJobCounters.createJob();
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        TestJobCounters.createWordsFile(inFiles[3], conf);
        this.removeWordsFile(inFiles[4], conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        inputSize += TestJobCounters.getFileSize(inFiles[3]);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{IN_DIR});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUT_DIR, "outputN1"));
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        org.apache.hadoop.mapred.Counters c1 = org.apache.hadoop.mapred.Counters.downgrade((Counters)job.getCounters());
        this.validateCounters(c1, 98304L, 20480L, 81920L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
    }

    @Test
    public void testNewCounterC() throws Exception {
        Job job = TestJobCounters.createJob();
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.factor", 3);
        TestJobCounters.createWordsFile(inFiles[3], conf);
        TestJobCounters.createWordsFile(inFiles[4], conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        inputSize += TestJobCounters.getFileSize(inFiles[3]);
        inputSize += TestJobCounters.getFileSize(inFiles[4]);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{IN_DIR});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUT_DIR, "outputN2"));
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        org.apache.hadoop.mapred.Counters c1 = org.apache.hadoop.mapred.Counters.downgrade((Counters)job.getCounters());
        this.validateCounters(c1, 122880L, 25600L, 102400L);
        this.validateFileCounters(c1, inputSize, 0L, 0L, 0L);
    }

    @Test
    public void testNewCounterD() throws Exception {
        Job job = TestJobCounters.createJob();
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.factor", 2);
        job.setNumReduceTasks(0);
        this.removeWordsFile(inFiles[3], conf);
        this.removeWordsFile(inFiles[4], conf);
        long inputSize = 0L;
        inputSize += TestJobCounters.getFileSize(inFiles[0]);
        inputSize += TestJobCounters.getFileSize(inFiles[1]);
        inputSize += TestJobCounters.getFileSize(inFiles[2]);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{IN_DIR});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUT_DIR, "outputN3"));
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
        org.apache.hadoop.mapred.Counters c1 = org.apache.hadoop.mapred.Counters.downgrade((Counters)job.getCounters());
        this.validateCounters(c1, 0L, 15360L, 61440L);
        this.validateFileCounters(c1, inputSize, 0L, -1L, -1L);
    }

    @Test
    public void testOldCounters() throws Exception {
        org.apache.hadoop.mapred.Counters c1 = new org.apache.hadoop.mapred.Counters();
        c1.incrCounter((Enum)FileInputFormat.Counter.BYTES_READ, 100L);
        c1.incrCounter((Enum)FileOutputFormat.Counter.BYTES_WRITTEN, 200L);
        c1.incrCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES, 100L);
        c1.incrCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES, 100L);
        this.validateFileCounters(c1, 100L, 200L, 100L, 100L);
        this.validateOldFileCounters(c1, 100L, 200L, 100L, 100L);
    }

    private long getTaskCounterUsage(JobClient client, JobID id, int numReports, int taskId, TaskType type) throws Exception {
        TaskReport[] reports = null;
        if (TaskType.MAP.equals((Object)type)) {
            reports = client.getMapTaskReports(id);
        } else if (TaskType.REDUCE.equals((Object)type)) {
            reports = client.getReduceTaskReports(id);
        }
        Assertions.assertNotNull((Object)reports, (String)("No reports found for task type '" + type.name() + "' in job " + id));
        Assertions.assertEquals((int)numReports, (int)reports.length, (String)"Mismatch in task id");
        org.apache.hadoop.mapred.Counters counters = reports[taskId].getCounters();
        return counters.getCounter((Enum)TaskCounter.COMMITTED_HEAP_BYTES);
    }

    private static RunningJob runHeapUsageTestJob(JobConf conf, Path testRootDir, String heapOptions, long targetMapValue, long targetReduceValue, FileSystem fs, JobClient client, Path inDir) throws IOException {
        JobConf jobConf = new JobConf((Configuration)conf);
        jobConf.setNumMapTasks(1);
        jobConf.setNumReduceTasks(1);
        jobConf.setMapperClass(MemoryLoaderMapper.class);
        jobConf.setReducerClass(MemoryLoaderReducer.class);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.setOutputKeyClass(LongWritable.class);
        jobConf.setOutputValueClass(Text.class);
        jobConf.setMaxMapAttempts(1);
        jobConf.setMaxReduceAttempts(1);
        jobConf.set("mapreduce.map.java.opts", heapOptions);
        jobConf.set("mapreduce.reduce.java.opts", heapOptions);
        jobConf.setLong("map.memory-loader.target-value", targetMapValue);
        jobConf.setLong("reduce.memory-loader.target-value", targetReduceValue);
        org.apache.hadoop.mapred.FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        Path outDir = new Path(testRootDir, "out");
        fs.delete(outDir, true);
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outDir);
        RunningJob job = client.submitJob(jobConf);
        job.waitForCompletion();
        JobID jobID = job.getID();
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)("Job " + jobID + " failed!"));
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeapUsageCounter() throws Exception {
        JobConf conf = new JobConf();
        LocalFileSystem fileSystem = FileSystem.getLocal((Configuration)conf);
        Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"));
        Path testRootDir = new Path(rootDir, "testHeapUsageCounter");
        fileSystem.delete(testRootDir, true);
        fileSystem.setWorkingDirectory(testRootDir);
        fileSystem.deleteOnExit(testRootDir);
        MiniMRCluster mrCluster = new MiniMRCluster(1, fileSystem.getUri().toString(), 1);
        try {
            conf = mrCluster.createJobConf();
            JobClient jobClient = new JobClient(conf);
            Path inDir = new Path(testRootDir, "in");
            TestJobCounters.createWordsFile(inDir, (Configuration)conf);
            RunningJob lowMemJob = TestJobCounters.runHeapUsageTestJob(conf, testRootDir, "-Xms32m -Xmx1G", 0L, 0L, (FileSystem)fileSystem, jobClient, inDir);
            JobID lowMemJobID = lowMemJob.getID();
            long lowMemJobMapHeapUsage = this.getTaskCounterUsage(jobClient, lowMemJobID, 1, 0, TaskType.MAP);
            System.out.println("Job1 (low memory job) map task heap usage: " + lowMemJobMapHeapUsage);
            long lowMemJobReduceHeapUsage = this.getTaskCounterUsage(jobClient, lowMemJobID, 1, 0, TaskType.REDUCE);
            System.out.println("Job1 (low memory job) reduce task heap usage: " + lowMemJobReduceHeapUsage);
            RunningJob highMemJob = TestJobCounters.runHeapUsageTestJob(conf, testRootDir, "-Xms32m -Xmx1G", lowMemJobMapHeapUsage + 0x10000000L, lowMemJobReduceHeapUsage + 0x10000000L, (FileSystem)fileSystem, jobClient, inDir);
            JobID highMemJobID = highMemJob.getID();
            long highMemJobMapHeapUsage = this.getTaskCounterUsage(jobClient, highMemJobID, 1, 0, TaskType.MAP);
            System.out.println("Job2 (high memory job) map task heap usage: " + highMemJobMapHeapUsage);
            long highMemJobReduceHeapUsage = this.getTaskCounterUsage(jobClient, highMemJobID, 1, 0, TaskType.REDUCE);
            System.out.println("Job2 (high memory job) reduce task heap usage: " + highMemJobReduceHeapUsage);
            Assertions.assertTrue((lowMemJobMapHeapUsage < highMemJobMapHeapUsage ? 1 : 0) != 0, (String)"Incorrect map heap usage reported by the map task");
            Assertions.assertTrue((lowMemJobReduceHeapUsage < highMemJobReduceHeapUsage ? 1 : 0) != 0, (String)"Incorrect reduce heap usage reported by the reduce task");
        }
        finally {
            mrCluster.shutdown();
            try {
                fileSystem.delete(testRootDir, true);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testMockResourceCalculatorProcessTree() {
        ResourceCalculatorProcessTree tree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"1", MockResourceCalculatorProcessTree.class, (Configuration)new Configuration());
        Assertions.assertNotNull((Object)tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxCounter() throws IOException, ClassNotFoundException, InterruptedException {
        MiniMRClientCluster mrCluster = MiniMRClientClusterFactory.create(this.getClass(), 2, new Configuration());
        try {
            Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"));
            Path testRootDir = new Path(rootDir, "testMaxCounter");
            Path testInputDir = new Path(testRootDir, "input");
            Path testOutputDir = new Path(testRootDir, "output");
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            fs.mkdirs(testInputDir);
            Path testInputFile = new Path(testInputDir, "file01");
            FSDataOutputStream stream = fs.create(testInputFile);
            stream.writeChars("foo");
            stream.writeChars("bar");
            stream.close();
            fs.delete(testOutputDir, true);
            Configuration conf = new Configuration();
            conf.setClass("mapreduce.job.process-tree.class", MockResourceCalculatorProcessTree.class, ResourceCalculatorProcessTree.class);
            Job job = Job.getInstance((Configuration)conf, (String)"word count");
            job.setJarByClass(WordCount.class);
            job.setMapperClass(TokenizerMapper.class);
            job.setCombinerClass(IntSumReducer.class);
            job.setReducerClass(IntSumReducer.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(IntWritable.class);
            job.setNumReduceTasks(2);
            FileInputFormat.addInputPath((Job)job, (Path)testInputDir);
            FileOutputFormat.setOutputPath((Job)job, (Path)testOutputDir);
            Assertions.assertTrue((boolean)job.waitForCompletion(true));
            Counter maxMap = job.getCounters().findCounter((Enum)TaskCounter.MAP_PHYSICAL_MEMORY_BYTES_MAX);
            Counter maxReduce = job.getCounters().findCounter((Enum)TaskCounter.REDUCE_PHYSICAL_MEMORY_BYTES_MAX);
            Counter allP = job.getCounters().findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES);
            Assertions.assertEquals((long)1024L, (long)maxMap.getValue());
            Assertions.assertEquals((long)1024L, (long)maxReduce.getValue());
            Assertions.assertEquals((long)3072L, (long)allP.getValue());
            Counter maxMapV = job.getCounters().findCounter((Enum)TaskCounter.MAP_VIRTUAL_MEMORY_BYTES_MAX);
            Counter maxReduceV = job.getCounters().findCounter((Enum)TaskCounter.REDUCE_VIRTUAL_MEMORY_BYTES_MAX);
            Counter allV = job.getCounters().findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES);
            Assertions.assertEquals((long)2000L, (long)maxMapV.getValue());
            Assertions.assertEquals((long)2000L, (long)maxReduceV.getValue());
            Assertions.assertEquals((long)6000L, (long)allV.getValue());
            Counter customerCounter = job.getCounters().findCounter((Enum)IntSumReducer.Counters.MY_COUNTER_MAX);
            Assertions.assertEquals((long)200L, (long)customerCounter.getValue());
            fs.delete(testInputDir, true);
            fs.delete(testOutputDir, true);
        }
        finally {
            mrCluster.stop();
        }
    }

    public static class MockResourceCalculatorProcessTree
    extends ResourceCalculatorProcessTree {
        public MockResourceCalculatorProcessTree(String root) {
            super(root);
        }

        public void updateProcessTree() {
        }

        public String getProcessTreeDump() {
            return "";
        }

        public long getCumulativeCpuTime() {
            return 0L;
        }

        public boolean checkPidPgrpidForMatch() {
            return true;
        }

        public long getRssMemorySize() {
            return 1024L;
        }

        public long getVirtualMemorySize() {
            return 2000L;
        }

        public float getCpuUsagePercent() {
            return 0.0f;
        }
    }

    public static class IntSumReducer
    extends org.apache.hadoop.mapreduce.Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
            context.getCounter((Enum)Counters.MY_COUNTER_MAX).increment(100L);
        }

        public static enum Counters {
            MY_COUNTER_MAX;

        }
    }

    public static class TokenizerMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable ONE = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)ONE);
            }
        }
    }

    public static class NewSummer
    extends org.apache.hadoop.mapreduce.Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    public static class NewMapTokenizer
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)one);
            }
        }
    }

    static class MemoryLoaderReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        static final String TARGET_VALUE = "reduce.memory-loader.target-value";
        private static MemoryLoader loader = null;

        MemoryLoaderReducer() {
        }

        public void reduce(WritableComparable key, Iterator<Writable> val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            Assertions.assertNotNull((Object)loader, (String)"Reducer not configured!");
            loader.load();
            output.collect((Object)key, (Object)key);
        }

        public void configure(JobConf conf) {
            loader = new MemoryLoader(conf.getLong(TARGET_VALUE, -1L));
        }
    }

    static class MemoryLoaderMapper
    extends MapReduceBase
    implements org.apache.hadoop.mapred.Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        static final String TARGET_VALUE = "map.memory-loader.target-value";
        private static MemoryLoader loader = null;

        MemoryLoaderMapper() {
        }

        public void map(WritableComparable key, Writable val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            Assertions.assertNotNull((Object)loader, (String)"Mapper not configured!");
            loader.load();
            output.collect((Object)key, (Object)val);
        }

        public void configure(JobConf conf) {
            loader = new MemoryLoader(conf.getLong(TARGET_VALUE, -1L));
        }
    }

    static class MemoryLoader {
        private static final int DEFAULT_UNIT_LOAD_SIZE = 0xA00000;
        private long targetValue;
        private List<String> loadObjects = new ArrayList<String>();

        MemoryLoader(long targetValue) {
            this.targetValue = targetValue;
        }

        void load() {
            while (Runtime.getRuntime().totalMemory() < this.targetValue) {
                System.out.println("Loading memory with 10485760 characters. Current usage : " + Runtime.getRuntime().totalMemory());
                this.loadObjects.add(RandomStringUtils.random((int)0xA00000));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

