/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJobClients {
    @Test
    public void testMapTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getMapTaskReports(id);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.length);
        ((Cluster)Mockito.verify((Object)mockCluster)).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testReduceTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getReduceTaskReports(id);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.length);
        ((Cluster)Mockito.verify((Object)mockCluster)).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testSetupTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getSetupTaskReports(id);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.length);
        ((Cluster)Mockito.verify((Object)mockCluster)).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testCleanupTaskReportsWithNullJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("test", 0);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.apache.hadoop.mapred.TaskReport[] result = client.getCleanupTaskReports(id);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.length);
        ((Cluster)Mockito.verify((Object)mockCluster)).getJob((org.apache.hadoop.mapreduce.JobID)id);
    }

    @Test
    public void testShowJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        long startTime = System.currentTimeMillis();
        JobID jobID = new JobID(String.valueOf(startTime), 12345);
        JobStatus mockJobStatus = (JobStatus)Mockito.mock(JobStatus.class);
        Mockito.when((Object)mockJobStatus.getJobID()).thenReturn((Object)jobID);
        Mockito.when((Object)mockJobStatus.getJobName()).thenReturn((Object)jobID.toString());
        Mockito.when((Object)mockJobStatus.getState()).thenReturn((Object)JobStatus.State.RUNNING);
        Mockito.when((Object)mockJobStatus.getStartTime()).thenReturn((Object)startTime);
        Mockito.when((Object)mockJobStatus.getUsername()).thenReturn((Object)"mockuser");
        Mockito.when((Object)mockJobStatus.getQueue()).thenReturn((Object)"mockqueue");
        Mockito.when((Object)mockJobStatus.getPriority()).thenReturn((Object)JobPriority.NORMAL);
        Mockito.when((Object)mockJobStatus.getNumUsedSlots()).thenReturn((Object)1);
        Mockito.when((Object)mockJobStatus.getNumReservedSlots()).thenReturn((Object)1);
        Mockito.when((Object)mockJobStatus.getUsedMem()).thenReturn((Object)1024);
        Mockito.when((Object)mockJobStatus.getReservedMem()).thenReturn((Object)512);
        Mockito.when((Object)mockJobStatus.getNeededMem()).thenReturn((Object)2048);
        Mockito.when((Object)mockJobStatus.getSchedulingInfo()).thenReturn((Object)"NA");
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTaskReports((TaskType)ArgumentMatchers.isA(TaskType.class))).thenReturn((Object)new TaskReport[5]);
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)jobID)).thenReturn((Object)mockJob);
        client.setCluster(mockCluster);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        client.displayJobList(new JobStatus[]{mockJobStatus}, new PrintWriter(out));
        String commandLineOutput = out.toString();
        System.out.println(commandLineOutput);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)commandLineOutput.contains("Total jobs:1"));
        ((JobStatus)Mockito.verify((Object)mockJobStatus, (VerificationMode)Mockito.atLeastOnce())).getJobID();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getState();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getStartTime();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getUsername();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getQueue();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getPriority();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getNumUsedSlots();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getNumReservedSlots();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getUsedMem();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getReservedMem();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getNeededMem();
        ((JobStatus)Mockito.verify((Object)mockJobStatus)).getSchedulingInfo();
        ((Cluster)Mockito.verify((Object)mockCluster, (VerificationMode)Mockito.never())).getJob((org.apache.hadoop.mapreduce.JobID)jobID);
        ((Job)Mockito.verify((Object)mockJob, (VerificationMode)Mockito.never())).getTaskReports((TaskType)ArgumentMatchers.isA(TaskType.class));
    }

    @Test
    public void testGetJobWithUnknownJob() throws Exception {
        TestJobClient client = new TestJobClient(new JobConf());
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        client.setCluster(mockCluster);
        JobID id = new JobID("unknown", 0);
        Mockito.when((Object)mockCluster.getJob((org.apache.hadoop.mapreduce.JobID)id)).thenReturn(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)client.getJob(id));
    }

    @Test
    public void testGetJobRetry() throws Exception {
        JobConf conf = new JobConf();
        conf.setInt("yarn.app.mapreduce.client.job.max-retries", 2);
        TestJobClientGetJob client = new TestJobClientGetJob(conf);
        JobID id = new JobID("ajob", 1);
        RunningJob rj = (RunningJob)Mockito.mock(RunningJob.class);
        client.setRunningJob(rj);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)client.getJob(id));
        Assertions.assertThat((int)client.getLastGetJobRetriesCounter()).isEqualTo(0);
        client.setGetJobRetries(2);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)client.getJob(id));
        Assertions.assertThat((int)client.getLastGetJobRetriesCounter()).isEqualTo(2);
        client.setGetJobRetries(3);
        org.junit.jupiter.api.Assertions.assertNull((Object)client.getJob(id));
    }

    @Test
    public void testGetJobRetryDefault() throws Exception {
        JobConf conf = new JobConf();
        TestJobClientGetJob client = new TestJobClientGetJob(conf);
        JobID id = new JobID("ajob", 1);
        RunningJob rj = (RunningJob)Mockito.mock(RunningJob.class);
        client.setRunningJob(rj);
        client.setGetJobRetries(3);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)client.getJob(id));
        Assertions.assertThat((int)client.getLastGetJobRetriesCounter()).isEqualTo(3);
        client.setGetJobRetries(4);
        org.junit.jupiter.api.Assertions.assertNull((Object)client.getJob(id));
    }

    public class TestJobClientGetJob
    extends TestJobClient {
        int lastGetJobRetriesCounter;
        int getJobRetriesCounter;
        int getJobRetries;
        RunningJob runningJob;

        TestJobClientGetJob(JobConf jobConf) throws IOException {
            super(jobConf);
            this.lastGetJobRetriesCounter = 0;
            this.getJobRetriesCounter = 0;
            this.getJobRetries = 0;
        }

        public int getLastGetJobRetriesCounter() {
            return this.lastGetJobRetriesCounter;
        }

        public void setGetJobRetries(int getJobRetries) {
            this.getJobRetries = getJobRetries;
        }

        public void setRunningJob(RunningJob runningJob) {
            this.runningJob = runningJob;
        }

        protected RunningJob getJobInner(JobID jobid) throws IOException {
            if (this.getJobRetriesCounter >= this.getJobRetries) {
                this.lastGetJobRetriesCounter = this.getJobRetriesCounter;
                this.getJobRetriesCounter = 0;
                return this.runningJob;
            }
            ++this.getJobRetriesCounter;
            return null;
        }
    }

    public class TestJobClient
    extends JobClient {
        TestJobClient(JobConf jobConf) throws IOException {
            super(jobConf);
        }

        void setCluster(Cluster cluster) {
            this.cluster = cluster;
        }
    }
}

