/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInputPath {
    @Test
    public void testInputPath() throws Exception {
        JobConf jobConf = new JobConf();
        Path workingDir = jobConf.getWorkingDirectory();
        Path path = new Path(workingDir, "xx{y,z}");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        Path[] paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)1, (int)paths.length);
        Assertions.assertEquals((Object)path.toString(), (Object)paths[0].toString());
        StringBuilder pathStr = new StringBuilder();
        pathStr.append('\\');
        pathStr.append('\\');
        pathStr.append(',');
        pathStr.append(',');
        pathStr.append('a');
        path = new Path(workingDir, pathStr.toString());
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)1, (int)paths.length);
        Assertions.assertEquals((Object)path.toString(), (Object)paths[0].toString());
        pathStr.setLength(0);
        pathStr.append('\\');
        pathStr.append("xx");
        pathStr.append('\\');
        path = new Path(workingDir, pathStr.toString());
        Path path1 = new Path(workingDir, "yy,zz");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        FileInputFormat.addInputPath((JobConf)jobConf, (Path)path1);
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)2, (int)paths.length);
        Assertions.assertEquals((Object)path.toString(), (Object)paths[0].toString());
        Assertions.assertEquals((Object)path1.toString(), (Object)paths[1].toString());
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path, path1});
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)2, (int)paths.length);
        Assertions.assertEquals((Object)path.toString(), (Object)paths[0].toString());
        Assertions.assertEquals((Object)path1.toString(), (Object)paths[1].toString());
        Path[] input = new Path[]{path, path1};
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])input);
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)2, (int)paths.length);
        Assertions.assertEquals((Object)path.toString(), (Object)paths[0].toString());
        Assertions.assertEquals((Object)path1.toString(), (Object)paths[1].toString());
        pathStr.setLength(0);
        String str1 = "{a{b,c},de}";
        String str2 = "xyz";
        String str3 = "x{y,z}";
        pathStr.append(str1);
        pathStr.append(',');
        pathStr.append(str2);
        pathStr.append(',');
        pathStr.append(str3);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)pathStr.toString());
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)3, (int)paths.length);
        Assertions.assertEquals((Object)new Path(workingDir, str1).toString(), (Object)paths[0].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str2).toString(), (Object)paths[1].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str3).toString(), (Object)paths[2].toString());
        pathStr.setLength(0);
        String str4 = "abc";
        String str5 = "pq{r,s}";
        pathStr.append(str4);
        pathStr.append(',');
        pathStr.append(str5);
        FileInputFormat.addInputPaths((JobConf)jobConf, (String)pathStr.toString());
        paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        Assertions.assertEquals((int)5, (int)paths.length);
        Assertions.assertEquals((Object)new Path(workingDir, str1).toString(), (Object)paths[0].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str2).toString(), (Object)paths[1].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str3).toString(), (Object)paths[2].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str4).toString(), (Object)paths[3].toString());
        Assertions.assertEquals((Object)new Path(workingDir, str5).toString(), (Object)paths[4].toString());
    }
}

