/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFileInputFormatPathFilter {
    private static FileSystem localFs = null;
    private static Path workDir;

    @BeforeEach
    public void setUp() throws Exception {
        this.tearDown();
        localFs.mkdirs(workDir);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (localFs.exists(workDir)) {
            localFs.delete(workDir, true);
        }
    }

    protected Path createFile(String fileName) throws IOException {
        Path file = new Path(workDir, fileName);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
        writer.write("");
        ((Writer)writer).close();
        return localFs.makeQualified(file);
    }

    protected Set<Path> createFiles() throws IOException {
        HashSet<Path> files = new HashSet<Path>();
        files.add(this.createFile("a"));
        files.add(this.createFile("b"));
        files.add(this.createFile("aa"));
        files.add(this.createFile("bb"));
        files.add(this.createFile("_hello"));
        files.add(this.createFile(".hello"));
        return files;
    }

    private void _testInputFiles(boolean withFilter, boolean withGlob) throws Exception {
        Set<Path> createdFiles = this.createFiles();
        JobConf conf = new JobConf();
        Path inputDir = withGlob ? new Path(workDir, "a*") : workDir;
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inputDir});
        conf.setInputFormat(DummyFileInputFormat.class);
        if (withFilter) {
            FileInputFormat.setInputPathFilter((JobConf)conf, TestPathFilter.class);
        }
        DummyFileInputFormat inputFormat = (DummyFileInputFormat)conf.getInputFormat();
        HashSet<Path> computedFiles = new HashSet<Path>();
        for (FileStatus file : inputFormat.listStatus(conf)) {
            computedFiles.add(file.getPath());
        }
        createdFiles.remove(localFs.makeQualified(new Path(workDir, "_hello")));
        createdFiles.remove(localFs.makeQualified(new Path(workDir, ".hello")));
        if (withFilter) {
            createdFiles.remove(localFs.makeQualified(new Path(workDir, "aa")));
            createdFiles.remove(localFs.makeQualified(new Path(workDir, "bb")));
        }
        if (withGlob) {
            createdFiles.remove(localFs.makeQualified(new Path(workDir, "b")));
            createdFiles.remove(localFs.makeQualified(new Path(workDir, "bb")));
        }
        Assertions.assertEquals(createdFiles, computedFiles);
    }

    @Test
    public void testWithoutPathFilterWithoutGlob() throws Exception {
        this._testInputFiles(false, false);
    }

    @Test
    public void testWithoutPathFilterWithGlob() throws Exception {
        this._testInputFiles(false, true);
    }

    @Test
    public void testWithPathFilterWithoutGlob() throws Exception {
        this._testInputFiles(true, false);
    }

    @Test
    public void testWithPathFilterWithGlob() throws Exception {
        this._testInputFiles(true, true);
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)new JobConf());
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestFileInputFormatPathFilter");
    }

    public static class TestPathFilter
    implements PathFilter {
        public boolean accept(Path path) {
            String name = path.getName();
            return name.equals("TestFileInputFormatPathFilter") || name.length() == 1;
        }
    }

    public static class DummyFileInputFormat
    extends FileInputFormat {
        public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }
}

