/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import testshell.ExternalMapReduce;

@Disabled
public class TestCommandLineJobSubmission {
    static final Path input = new Path("/test/input/");
    static final Path output = new Path("/test/output");
    File buildDir = new File(System.getProperty("test.build.data", "/tmp"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobShell() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fs = null;
        Path testFile = new Path(input, "testfile");
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            fs = dfs.getFileSystem();
            FSDataOutputStream stream = fs.create(testFile);
            stream.write("teststring".getBytes());
            stream.close();
            mr = new MiniMRCluster(2, fs.getUri().toString(), 1);
            File thisbuildDir = new File(this.buildDir, "jobCommand");
            Assertions.assertTrue((boolean)thisbuildDir.mkdirs(), (String)"create build dir");
            File f = new File(thisbuildDir, "files_tmp");
            FileOutputStream fstream = new FileOutputStream(f);
            fstream.write("somestrings".getBytes());
            fstream.close();
            File f1 = new File(thisbuildDir, "files_tmp1");
            fstream = new FileOutputStream(f1);
            fstream.write("somestrings".getBytes());
            fstream.close();
            Path cachePath = new Path("/cacheDir");
            if (!fs.mkdirs(cachePath)) {
                throw new IOException("Mkdirs failed to create " + cachePath.toString());
            }
            Path localCachePath = new Path(System.getProperty("test.cache.data"));
            Path txtPath = new Path(localCachePath, new Path("test.txt"));
            Path jarPath = new Path(localCachePath, new Path("test.jar"));
            Path zipPath = new Path(localCachePath, new Path("test.zip"));
            Path tarPath = new Path(localCachePath, new Path("test.tar"));
            Path tgzPath = new Path(localCachePath, new Path("test.tgz"));
            fs.copyFromLocalFile(txtPath, cachePath);
            fs.copyFromLocalFile(jarPath, cachePath);
            fs.copyFromLocalFile(zipPath, cachePath);
            String[] files = new String[]{f.toString(), f1.toString() + "#localfilelink", fs.getUri().resolve(cachePath + "/test.txt#dfsfilelink").toString()};
            String[] libjars = new String[]{"build/test/mapred/testjar/testjob.jar", fs.getUri().resolve(cachePath + "/test.jar").toString()};
            String[] archives = new String[]{tgzPath.toString(), tarPath + "#tarlink", fs.getUri().resolve(cachePath + "/test.zip#ziplink").toString()};
            String[] args = new String[]{"-files", StringUtils.arrayToString((String[])files), "-libjars", StringUtils.arrayToString((String[])libjars), "-archives", StringUtils.arrayToString((String[])archives), "-D", "mapred.output.committer.class=testjar.CustomOutputCommitter", input.toString(), output.toString()};
            JobConf jobConf = mr.createJobConf();
            Assertions.assertTrue((this.loadLibJar(jobConf) == null ? 1 : 0) != 0, (String)"libjar not in client classpath");
            int ret = ToolRunner.run((Configuration)jobConf, (Tool)new ExternalMapReduce(), (String[])args);
            Assertions.assertTrue((this.loadLibJar(jobConf) != null ? 1 : 0) != 0, (String)"libjar added to client classpath");
            Assertions.assertTrue((ret != -1 ? 1 : 0) != 0, (String)"not failed ");
            f.delete();
            thisbuildDir.delete();
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    private Class loadLibJar(JobConf jobConf) {
        try {
            return jobConf.getClassByName("testjar.ClassWordCount");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

