/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.Assertions;

public class MRCaching {
    static String testStr = "This is a test file used for testing caching jars, zip and normal files.";

    static void setupCache(String cacheDir, FileSystem fs) throws IOException {
        Path localPath = new Path(System.getProperty("test.cache.data", "build/test/cache"));
        Path txtPath = new Path(localPath, new Path("test.txt"));
        Path jarPath = new Path(localPath, new Path("test.jar"));
        Path zipPath = new Path(localPath, new Path("test.zip"));
        Path tarPath = new Path(localPath, new Path("test.tgz"));
        Path tarPath1 = new Path(localPath, new Path("test.tar.gz"));
        Path tarPath2 = new Path(localPath, new Path("test.tar"));
        Path cachePath = new Path(cacheDir);
        fs.delete(cachePath, true);
        if (!fs.mkdirs(cachePath)) {
            throw new IOException("Mkdirs failed to create " + cachePath.toString());
        }
        fs.copyFromLocalFile(txtPath, cachePath);
        fs.copyFromLocalFile(jarPath, cachePath);
        fs.copyFromLocalFile(zipPath, cachePath);
        fs.copyFromLocalFile(tarPath, cachePath);
        fs.copyFromLocalFile(tarPath1, cachePath);
        fs.copyFromLocalFile(tarPath2, cachePath);
    }

    public static TestResult launchMRCache(String indir, String outdir, String cacheDir, JobConf conf, String input) throws IOException {
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
        Path inDir = new Path(indir);
        Path outDir = new Path(outdir);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        System.out.println("HERE:" + inDir);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("cachetest");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setCombinerClass(ReduceClass.class);
        conf.setReducerClass(ReduceClass.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
        conf.setSpeculativeExecution(false);
        URI[] uris = new URI[6];
        conf.setMapperClass(MapClass2.class);
        uris[0] = fs.getUri().resolve(cacheDir + "/test.txt");
        uris[1] = fs.getUri().resolve(cacheDir + "/test.jar");
        uris[2] = fs.getUri().resolve(cacheDir + "/test.zip");
        uris[3] = fs.getUri().resolve(cacheDir + "/test.tgz");
        uris[4] = fs.getUri().resolve(cacheDir + "/test.tar.gz");
        uris[5] = fs.getUri().resolve(cacheDir + "/test.tar");
        Job.addCacheFile((URI)uris[0], (Configuration)conf);
        long[] fileSizes = new long[]{fs.getFileStatus(new Path(uris[0].getPath())).getLen()};
        long[] archiveSizes = new long[5];
        for (int i = 1; i < 6; ++i) {
            Job.addCacheArchive((URI)uris[i], (Configuration)conf);
            archiveSizes[i - 1] = fs.getFileStatus(new Path(uris[i].getPath())).getLen();
        }
        RunningJob job = JobClient.runJob((JobConf)conf);
        int count = 0;
        Path result = new Path(TEST_ROOT_DIR + "/test.txt");
        BufferedReader file2 = new BufferedReader(new InputStreamReader((InputStream)FileSystem.getLocal((Configuration)conf).open(result)));
        String line = file2.readLine();
        while (line != null) {
            if (!testStr.equals(line)) {
                return new TestResult(job, false);
            }
            ++count;
            line = file2.readLine();
        }
        file2.close();
        if (count != 6) {
            return new TestResult(job, false);
        }
        MRCaching.validateCacheFileSizes(job.getConfiguration(), fileSizes, "mapreduce.job.cache.files.filesizes");
        MRCaching.validateCacheFileSizes(job.getConfiguration(), archiveSizes, "mapreduce.job.cache.archives.filesizes");
        return new TestResult(job, true);
    }

    private static void validateCacheFileSizes(Configuration job, long[] expectedSizes, String configKey) throws IOException {
        String configValues = job.get(configKey, "");
        System.out.println(configKey + " -> " + configValues);
        String[] realSizes = StringUtils.getStrings((String)configValues);
        Assertions.assertEquals((int)expectedSizes.length, (int)realSizes.length, (String)("Number of files for " + configKey));
        for (int i = 0; i < expectedSizes.length; ++i) {
            long actual = Long.valueOf(realSizes[i]);
            long expected = expectedSizes[i];
            Assertions.assertEquals((long)expected, (long)actual, (String)("File " + i + " for " + configKey));
        }
    }

    public static class TestResult {
        public RunningJob job;
        public boolean isOutputOk;

        TestResult(RunningJob job, boolean isOutputOk) {
            this.job = job;
            this.isOutputOk = isOutputOk;
        }
    }

    public static class ReduceClass
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, IntWritable> {
        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            output.collect((Object)key, (Object)new IntWritable(sum));
        }
    }

    public static class MapClass2
    extends MapClass {
        JobConf conf;

        @Override
        public void configure(JobConf jconf) {
            this.conf = jconf;
            try {
                String TEST_ROOT_DIR = jconf.get("test.build.data", "/tmp");
                Path file = new Path("file:///", TEST_ROOT_DIR);
                LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
                if (!fs.mkdirs(file)) {
                    throw new IOException("Mkdirs failed to create " + file.toString());
                }
                Path fileOut = new Path(file, "test.txt");
                fs.delete(fileOut, true);
                FSDataOutputStream out = fs.create(fileOut);
                String[] symlinks = new String[]{".", "testjar", "testzip", "testtgz", "testtargz", "testtar"};
                for (int i = 0; i < symlinks.length; ++i) {
                    File f = new File(symlinks[i]);
                    File txt = new File(f, "test.txt");
                    FileInputStream fin = new FileInputStream(txt);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                    String str = reader.readLine();
                    reader.close();
                    out.writeBytes(str);
                    out.writeBytes("\n");
                }
                out.close();
            }
            catch (IOException ie) {
                System.out.println(StringUtils.stringifyException((Throwable)ie));
            }
        }
    }

    public static class MapClass
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        JobConf conf;
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void configure(JobConf jconf) {
            this.conf = jconf;
            try {
                int i;
                Path[] localArchives = JobContextImpl.getLocalCacheArchives((Configuration)this.conf);
                Path[] localFiles = JobContextImpl.getLocalCacheFiles((Configuration)this.conf);
                String TEST_ROOT_DIR = jconf.get("test.build.data", "/tmp");
                Path file = new Path("file:///", TEST_ROOT_DIR);
                LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
                if (!fs.mkdirs(file)) {
                    throw new IOException("Mkdirs failed to create " + file.toString());
                }
                Path fileOut = new Path(file, "test.txt");
                fs.delete(fileOut, true);
                FSDataOutputStream out = fs.create(fileOut);
                for (i = 0; i < localArchives.length; ++i) {
                    File f = new File(localArchives[i].toString());
                    File txt = new File(f, "test.txt");
                    FileInputStream fin = new FileInputStream(txt);
                    DataInputStream din = new DataInputStream(fin);
                    String str = din.readLine();
                    din.close();
                    out.writeBytes(str);
                    out.writeBytes("\n");
                }
                for (i = 0; i < localFiles.length; ++i) {
                    File txt = new File(localFiles[i].toString());
                    FileInputStream fin = new FileInputStream(txt);
                    DataInputStream din = new DataInputStream(fin);
                    String str = din.readLine();
                    out.writeBytes(str);
                    out.writeBytes("\n");
                }
                out.close();
            }
            catch (IOException ie) {
                System.out.println(StringUtils.stringifyException((Throwable)ie));
            }
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            String line = value.toString();
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                output.collect((Object)this.word, (Object)one);
            }
        }
    }
}

