/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;

public class TestSequenceFileMergeProgress {
    private static final Logger LOG = FileInputFormat.LOG;
    private static final int RECORDS = 10000;

    @Test
    public void testMergeProgressWithNoCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.NONE);
    }

    @Test
    public void testMergeProgressWithRecordCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.RECORD);
    }

    @Test
    public void testMergeProgressWithBlockCompression() throws IOException {
        this.runTest(SequenceFile.CompressionType.BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(SequenceFile.CompressionType compressionType) throws IOException {
        JobConf job = new JobConf();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)job);
        Path dir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        Path file = new Path(dir, "test.seq");
        Path tempDir = new Path(dir, "tmp");
        fs.delete(dir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
        fs.mkdirs(tempDir);
        LongWritable tkey = new LongWritable();
        Text tval = new Text();
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)file, LongWritable.class, Text.class, (SequenceFile.CompressionType)compressionType, (CompressionCodec)new DefaultCodec());){
            for (int i = 0; i < 10000; ++i) {
                tkey.set(1234L);
                tval.set("valuevaluevaluevaluevaluevaluevaluevaluevaluevaluevalue");
                writer.append((Writable)tkey, (Writable)tval);
            }
        }
        long fileLength = fs.getFileStatus(file).getLen();
        LOG.info("With compression = " + compressionType + ": compressed length = " + fileLength);
        SequenceFile.Sorter sorter = new SequenceFile.Sorter((FileSystem)fs, job.getOutputKeyComparator(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), (Configuration)job);
        Path[] paths = new Path[]{file};
        SequenceFile.Sorter.RawKeyValueIterator rIter = sorter.merge(paths, tempDir, false);
        int count = 0;
        while (rIter.next()) {
            ++count;
        }
        Assertions.assertEquals((int)10000, (int)count);
        Assertions.assertEquals((double)1.0, (double)rIter.getProgress().get(), (double)0.0);
    }
}

