/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NNBench;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNNBench
extends HadoopTestCase {
    private static final String BASE_DIR = new File(System.getProperty("test.build.data", "build/test/data"), "NNBench").getAbsolutePath();
    private static final String CONTROL_DIR_NAME = "control";

    public TestNNBench() throws IOException {
        super(1, 4, 1, 1);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.getFileSystem().delete(new Path(BASE_DIR), true);
        this.getFileSystem().delete(new Path("NNBench_results.log"), true);
        super.tearDown();
    }

    @Test
    @Timeout(value=30L)
    public void testNNBenchCreateReadAndDelete() throws Exception {
        this.runNNBench((Configuration)this.createJobConf(), "create_write");
        Path path = new Path(BASE_DIR + "/data/file_0_0");
        Assertions.assertTrue((boolean)this.getFileSystem().exists(path), (String)"create_write should create the file");
        this.runNNBench((Configuration)this.createJobConf(), "open_read");
        this.runNNBench((Configuration)this.createJobConf(), "delete");
        Assertions.assertFalse((boolean)this.getFileSystem().exists(path), (String)"Delete operation should delete the file");
    }

    @Test
    @Timeout(value=30L)
    public void testNNBenchCreateAndRename() throws Exception {
        this.runNNBench((Configuration)this.createJobConf(), "create_write");
        Path path = new Path(BASE_DIR + "/data/file_0_0");
        Assertions.assertTrue((boolean)this.getFileSystem().exists(path), (String)"create_write should create the file");
        this.runNNBench((Configuration)this.createJobConf(), "rename");
        Path renamedPath = new Path(BASE_DIR + "/data/file_0_r_0");
        Assertions.assertFalse((boolean)this.getFileSystem().exists(path), (String)"Rename should rename the file");
        Assertions.assertTrue((boolean)this.getFileSystem().exists(renamedPath), (String)"Rename should rename the file");
    }

    @Test
    @Timeout(value=30L)
    public void testNNBenchCreateControlFilesWithPool() throws Exception {
        this.runNNBench((Configuration)this.createJobConf(), "create_write", BASE_DIR, "5");
        Path path = new Path(BASE_DIR, CONTROL_DIR_NAME);
        FileStatus[] fileStatuses = this.getFileSystem().listStatus(path);
        Assertions.assertEquals((int)5, (int)fileStatuses.length);
    }

    @Test
    @Timeout(value=30L)
    public void testNNBenchCrossCluster() throws Exception {
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder((Configuration)new JobConf()).numDataNodes(1).build();
        dfsCluster.waitClusterUp();
        String nnAddress = dfsCluster.getNameNode(0).getHostAndPort();
        String baseDir = "hdfs://" + nnAddress + BASE_DIR;
        this.runNNBench((Configuration)this.createJobConf(), "create_write", baseDir);
        Path path = new Path(BASE_DIR + "/data/file_0_0");
        Assertions.assertTrue((boolean)dfsCluster.getFileSystem().exists(path), (String)"create_write should create the file");
        dfsCluster.shutdown();
    }

    private void runNNBench(Configuration conf, String operation, String baseDir) throws Exception {
        String[] genArgs = new String[]{"-operation", operation, "-baseDir", baseDir, "-startTime", "" + (Time.now() / 1000L + 3L), "-blockSize", "1024"};
        Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new NNBench(), (String[])genArgs));
    }

    private void runNNBench(Configuration conf, String operation, String baseDir, String numMaps) throws Exception {
        String[] genArgs = new String[]{"-operation", operation, "-baseDir", baseDir, "-startTime", "" + (Time.now() / 1000L + 3L), "-blockSize", "1024", "-maps", numMaps};
        Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new NNBench(), (String[])genArgs));
    }

    private void runNNBench(Configuration conf, String operation) throws Exception {
        this.runNNBench(conf, operation, BASE_DIR);
    }
}

