/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.RunJar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMRCJCRunJar {
    private static String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString();
    private static final String TEST_JAR_NAME = "testjar.jar";
    private static final String CLASS_NAME = "Hello.class";

    @Test
    public void testRunjar() throws Throwable {
        File outFile = new File(TEST_ROOT_DIR, "out");
        if (outFile.exists()) {
            outFile.delete();
        }
        File makeTestJar = this.makeTestJar();
        String[] args = new String[]{makeTestJar.getAbsolutePath(), "org.apache.hadoop.util.Hello", outFile.toString()};
        RunJar.main((String[])args);
        Assertions.assertTrue((boolean)outFile.exists(), (String)"RunJar failed");
    }

    private File makeTestJar() throws IOException {
        int count;
        File jarFile = new File(TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        InputStream entryInputStream = this.getClass().getResourceAsStream(CLASS_NAME);
        ZipEntry entry = new ZipEntry("org/apache/hadoop/util/Hello.class");
        jstream.putNextEntry(entry);
        BufferedInputStream bufInputStream = new BufferedInputStream(entryInputStream, 2048);
        byte[] data = new byte[2048];
        while ((count = bufInputStream.read(data, 0, 2048)) != -1) {
            jstream.write(data, 0, count);
        }
        jstream.closeEntry();
        jstream.close();
        return jarFile;
    }
}

