/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNonExistentJob {
    private MiniDFSCluster dfsCluster = null;
    private MiniMRCluster mrCluster = null;

    @BeforeEach
    public void setUp() throws Exception {
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", "/tmp");
        }
        int taskTrackers = 2;
        int dataNodes = 2;
        String proxyUser = System.getProperty("user.name");
        String proxyGroup = "g";
        StringBuilder sb = new StringBuilder();
        sb.append("127.0.0.1,localhost");
        for (InetAddress i : InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            sb.append(",").append(i.getCanonicalHostName());
        }
        JobConf conf = new JobConf();
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        this.dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(dataNodes).build();
        DistributedFileSystem fileSystem = this.dfsCluster.getFileSystem();
        fileSystem.mkdirs(new Path("/tmp"));
        fileSystem.mkdirs(new Path("/user"));
        fileSystem.mkdirs(new Path("/hadoop/mapred/system"));
        fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
        fileSystem.setPermission(new Path("/hadoop/mapred/system"), FsPermission.valueOf((String)"-rwx------"));
        String nnURI = fileSystem.getUri().toString();
        int numDirs = 1;
        String[] racks = null;
        String[] hosts = null;
        this.mrCluster = new MiniMRCluster(0, 0, taskTrackers, nnURI, numDirs, racks, hosts, null, conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    protected JobConf getJobConf() {
        return this.mrCluster.createJobConf();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.shutdown();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
    }

    @Test
    public void testGetInvalidJob() throws Exception {
        RunningJob runJob = new JobClient(this.getJobConf()).getJob(JobID.forName((String)"job_0_0"));
        Assertions.assertNull((Object)runJob);
    }
}

