/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.avro.AvroRemoteException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.Records;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRJobsWithHistoryService {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRJobsWithHistoryService.class);
    private static final EnumSet<RMAppState> TERMINAL_RM_APP_STATES = EnumSet.of(RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED);
    private static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    @BeforeEach
    public void setup() throws InterruptedException, IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(this.getClass().getName());
            mrCluster.init(new Configuration());
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterEach
    public void tearDown() {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mrCluster != null) {
            mrCluster.stop();
        }
    }

    @Test
    @Timeout(value=90L)
    public void testJobHistoryData() throws IOException, InterruptedException, AvroRemoteException, ClassNotFoundException {
        ApplicationId appID;
        JobId jobId;
        Counters counterMR;
        Job job;
        block2: {
            if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
                LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
                return;
            }
            SleepJob sleepJob = new SleepJob();
            sleepJob.setConf(mrCluster.getConfig());
            job = sleepJob.createJob(3, 2, 1000L, 1, 500L, 1);
            job.setJarByClass(SleepJob.class);
            job.addFileToClassPath(APP_JAR);
            job.waitForCompletion(true);
            counterMR = job.getCounters();
            jobId = TypeConverter.toYarn((JobID)job.getJobID());
            appID = jobId.getAppId();
            int pollElapsed = 0;
            do {
                Thread.sleep(1000L);
                pollElapsed += 1000;
                if (TERMINAL_RM_APP_STATES.contains(((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState())) break block2;
            } while (pollElapsed < 60000);
            LOG.warn("application did not reach terminal state within 60 seconds");
        }
        Assertions.assertEquals((Object)RMAppState.FINISHED, (Object)((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState());
        Counters counterHS = job.getCounters();
        LOG.info("CounterHS " + counterHS);
        LOG.info("CounterMR " + counterMR);
        Assertions.assertEquals((Object)counterHS, (Object)counterMR);
        HSClientProtocol historyClient = this.instantiateHistoryProxy();
        GetJobReportRequest gjReq = (GetJobReportRequest)Records.newRecord(GetJobReportRequest.class);
        gjReq.setJobId(jobId);
        JobReport jobReport = historyClient.getJobReport(gjReq).getJobReport();
        this.verifyJobReport(jobReport, jobId);
    }

    private void verifyJobReport(JobReport jobReport, JobId jobId) {
        List amInfos = jobReport.getAMInfos();
        Assertions.assertEquals((int)1, (int)amInfos.size());
        AMInfo amInfo = (AMInfo)amInfos.get(0);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)jobId.getAppId(), (int)1);
        ContainerId amContainerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Assertions.assertEquals((Object)appAttemptId, (Object)amInfo.getAppAttemptId());
        Assertions.assertEquals((Object)amContainerId, (Object)amInfo.getContainerId());
        Assertions.assertTrue((jobReport.getSubmitTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((jobReport.getStartTime() > 0L && jobReport.getStartTime() >= jobReport.getSubmitTime() ? 1 : 0) != 0);
        Assertions.assertTrue((jobReport.getFinishTime() > 0L && jobReport.getFinishTime() >= jobReport.getStartTime() ? 1 : 0) != 0);
    }

    private HSClientProtocol instantiateHistoryProxy() {
        String serviceAddr = mrCluster.getConfig().get("mapreduce.jobhistory.address");
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        HSClientProtocol historyClient = (HSClientProtocol)rpc.getProxy(HSClientProtocol.class, NetUtils.createSocketAddr((String)serviceAddr), mrCluster.getConfig());
        return historyClient;
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = localFs.makeQualified(new Path("target", TestMRJobs.class.getName() + "-tmpDir"));
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

