/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRAMWithNonNormalizedCapabilities {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRAMWithNonNormalizedCapabilities.class);
    private static FileSystem localFs;
    protected static MiniMRYarnCluster mrCluster;
    private static Configuration conf;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    @BeforeEach
    public void setup() throws Exception {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(this.getClass().getSimpleName());
            mrCluster.init(new Configuration());
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @Test
    public void testJobWithNonNormalizedCapabilities() throws Exception {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        JobConf jobConf = new JobConf(mrCluster.getConfig());
        jobConf.setInt("mapreduce.map.memory.mb", 700);
        jobConf.setInt("mapred.reduce.memory.mb", 1500);
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf((Configuration)jobConf);
        Job job = sleepJob.createJob(3, 2, 1000L, 1, 500L, 1);
        job.setJarByClass(SleepJob.class);
        job.addFileToClassPath(APP_JAR);
        job.submit();
        boolean completed = job.waitForCompletion(true);
        Assertions.assertTrue((boolean)completed, (String)"Job should be completed");
        Assertions.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState(), (String)"Job should be finished successfully");
    }

    @AfterEach
    public void tearDown() {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test.");
            return;
        }
        if (mrCluster != null) {
            mrCluster.stop();
        }
    }

    static {
        mrCluster = null;
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMRAMWithNonNormalizedCapabilities.class.getName() + "-tmpDir").makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

