/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.partition.KeyFieldBasedPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMRKeyFieldBasedPartitioner {
    @Test
    public void testEmptyKey() throws Exception {
        int numReducers = 10;
        KeyFieldBasedPartitioner kfbp = new KeyFieldBasedPartitioner();
        Configuration conf = new Configuration();
        conf.setInt("num.key.fields.for.partition", 10);
        kfbp.setConf(conf);
        Assertions.assertEquals((int)0, (int)kfbp.getPartition((Object)new Text(), (Object)new Text(), numReducers), (String)"Empty key should map to 0th partition");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        kfbp.setConf(conf);
        String input = "abc\tdef\txyz";
        int hashCode = input.hashCode();
        int expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k2,2");
        kfbp.setConf(conf);
        String expectedOutput = "def";
        byte[] eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k2,5");
        kfbp.setConf(conf);
        expectedOutput = "def\txyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k2");
        kfbp.setConf(conf);
        expectedOutput = "def\txyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k10");
        kfbp.setConf(conf);
        Assertions.assertEquals((int)0, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k2,2 -k4,4");
        kfbp.setConf(conf);
        input = "abc\tdef\tpqr\txyz";
        expectedOutput = "def";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedOutput = "xyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, hashCode);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
        kfbp = new KeyFieldBasedPartitioner();
        conf = new Configuration();
        conf.set(KeyFieldBasedPartitioner.PARTITIONER_OPTIONS, "-k2,2 -k30,21 -k4,4 -k5");
        kfbp.setConf(conf);
        expectedOutput = "def";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, 0);
        expectedOutput = "xyz";
        eBytes = expectedOutput.getBytes();
        hashCode = kfbp.hashCode(eBytes, 0, eBytes.length - 1, hashCode);
        expectedPartition = kfbp.getPartition(hashCode, numReducers);
        Assertions.assertEquals((int)expectedPartition, (int)kfbp.getPartition((Object)new Text(input), (Object)new Text(), numReducers), (String)"Partitioner doesnt work as expected");
    }
}

