/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import org.apache.hadoop.mapreduce.lib.partition.KeyFieldHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKeyFieldHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TestKeyFieldHelper.class);

    @Test
    public void testparseOption() throws Exception {
        String keySpecs;
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        String eKeySpecs = keySpecs = "-k1.2,3.4";
        helper.parseOption(keySpecs);
        String actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k 1.2";
        eKeySpecs = "-k1.2,0.0";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr -k1.2,3.4";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr -k1.2,3.4n";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr -k1.2,3.4r";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr -k1.2,3.4 -k5.6,7.8n -k9.10,11.12r -k13.14,15.16nr";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8n";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k9.10,11.12r";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(2)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k13.14,15.16nr";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(3)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2n,3.4";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2r,3.4";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2nr,3.4";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4n";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4r";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4nr";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8nr";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-n -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8n";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-r -k1.2,3.4 -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8r";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4n -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4r -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-k1.2,3.4nr -k5.6,7.8";
        eKeySpecs = "-k1.2,3.4nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        eKeySpecs = "-k5.6,7.8";
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(1)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-n";
        eKeySpecs = "-k1.1,0.0n";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-r";
        eKeySpecs = "-k1.1,0.0r";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
        keySpecs = "-nr";
        eKeySpecs = "-k1.1,0.0nr";
        helper = new KeyFieldHelper();
        helper.parseOption(keySpecs);
        actKeySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        Assertions.assertEquals((Object)eKeySpecs, (Object)actKeySpecs, (String)"KeyFieldHelper's parsing is garbled");
    }

    @Test
    public void testGetWordLengths() throws Exception {
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        String input = "hi";
        int[] result = helper.getWordLengths(input.getBytes(), 0, 2);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{1}));
        helper.setKeyFieldSpec(1, 2);
        input = "hi\thello there";
        result = helper.getWordLengths(input.getBytes(), 0, input.length());
        Assertions.assertTrue((boolean)this.equals(result, new int[]{2, 2, 11}));
        helper.setKeyFieldSeparator(" ");
        input = "hi hello\tthere you";
        result = helper.getWordLengths(input.getBytes(), 0, input.length());
        Assertions.assertTrue((boolean)this.equals(result, new int[]{3, 2, 11, 3}));
        input = "hi hello there you where me there";
        result = helper.getWordLengths(input.getBytes(), 10, 33);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{5, 4, 3, 5, 2, 3}));
        input = "hi hello there you where me ";
        result = helper.getWordLengths(input.getBytes(), 10, input.length());
        Assertions.assertTrue((boolean)this.equals(result, new int[]{5, 4, 3, 5, 2, 0}));
        input = "";
        result = helper.getWordLengths(input.getBytes(), 0, 0);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{1, 0}));
        input = "  abc";
        result = helper.getWordLengths(input.getBytes(), 0, 5);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{3, 0, 0, 3}));
        input = "  abc";
        result = helper.getWordLengths(input.getBytes(), 0, 2);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{3, 0, 0, 0}));
        input = " abc ";
        result = helper.getWordLengths(input.getBytes(), 0, 2);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{2, 0, 1}));
        helper.setKeyFieldSeparator("abcd");
        input = "abc";
        result = helper.getWordLengths(input.getBytes(), 0, 3);
        Assertions.assertTrue((boolean)this.equals(result, new int[]{1, 3}));
    }

    @Test
    public void testgetStartEndOffset() throws Exception {
        String input;
        KeyFieldHelper helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.setKeyFieldSpec(1, 2);
        String expectedOutput = input = "hi\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.0,0");
        this.testKeySpecs(input, null, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1,0");
        expectedOutput = input;
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,0");
        expectedOutput = "i\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.1,2.3");
        expectedOutput = "hi\thel";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,2.3");
        expectedOutput = "i\thel";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k1.2,3.0");
        expectedOutput = "i\thello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2,2");
        expectedOutput = "hello";
        this.testKeySpecs(input, expectedOutput, helper);
        helper = new KeyFieldHelper();
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k3.1,4.0");
        this.testKeySpecs(input, null, helper);
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1");
        expectedOutput = "hello\thow";
        this.testKeySpecs(input, expectedOutput, helper, 15, input.length());
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\t\thow\tare";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1,3");
        expectedOutput = "hello\t";
        this.testKeySpecs(input, expectedOutput, helper, 17, input.length());
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow\tare";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1");
        expectedOutput = "hello\thow\t";
        this.testKeySpecs(input, expectedOutput, helper, 17, 28);
        helper = new KeyFieldHelper();
        input = "123123123123123hi\thello\thow";
        helper.setKeyFieldSeparator("\t");
        helper.parseOption("-k2.1,3");
        expectedOutput = "hello";
        this.testKeySpecs(input, expectedOutput, helper, 15, 23);
    }

    private void testKeySpecs(String input, String expectedOutput, KeyFieldHelper helper) {
        this.testKeySpecs(input, expectedOutput, helper, 0, -1);
    }

    private void testKeySpecs(String input, String expectedOutput, KeyFieldHelper helper, int s1, int e1) {
        LOG.info("input : " + input);
        String keySpecs = ((KeyFieldHelper.KeyDescription)helper.keySpecs().get(0)).toString();
        LOG.info("keyspecs : " + keySpecs);
        byte[] inputBytes = input.getBytes();
        if (e1 == -1) {
            e1 = inputBytes.length;
        }
        LOG.info("length : " + e1);
        int[] indices = helper.getWordLengths(inputBytes, s1, e1);
        int start = helper.getStartOffset(inputBytes, s1, e1, indices, (KeyFieldHelper.KeyDescription)helper.keySpecs().get(0));
        LOG.info("start : " + start);
        if (expectedOutput == null) {
            Assertions.assertEquals((int)-1, (int)start, (String)"Expected -1 when the start index is invalid");
            return;
        }
        int end = helper.getEndOffset(inputBytes, s1, e1, indices, (KeyFieldHelper.KeyDescription)helper.keySpecs().get(0));
        LOG.info("end : " + end);
        end = end >= inputBytes.length ? inputBytes.length - 1 : end;
        int length = end + 1 - start;
        LOG.info("length : " + length);
        byte[] outputBytes = new byte[length];
        System.arraycopy(inputBytes, start, outputBytes, 0, length);
        String output = new String(outputBytes);
        LOG.info("output : " + output);
        LOG.info("expected-output : " + expectedOutput);
        Assertions.assertEquals((Object)expectedOutput, (Object)output, (String)(keySpecs + " failed on input '" + input + "'"));
    }

    private boolean equals(int[] test, int[] expected) {
        if (test[0] != expected[0]) {
            return false;
        }
        for (int i = 0; i < test[0] && i < expected[0]; ++i) {
            if (test[i] == expected[i]) continue;
            return false;
        }
        return true;
    }
}

