/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.map;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.map.MultithreadedMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultithreadedMapper
extends HadoopTestCase {
    public TestMultithreadedMapper() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testOKRun() throws Exception {
        this.run(false, false);
    }

    @Test
    public void testIOExRun() throws Exception {
        this.run(true, false);
    }

    @Test
    public void testRuntimeExRun() throws Exception {
        this.run(false, true);
    }

    private void run(boolean ioEx, boolean rtEx) throws Exception {
        String localPathRoot = System.getProperty("test.build.data", "/tmp");
        Path inDir = new Path(localPathRoot, "testing/mt/input");
        Path outDir = new Path(localPathRoot, "testing/mt/output");
        JobConf conf = this.createJobConf();
        if (ioEx) {
            conf.setBoolean("multithreaded.ioException", true);
        }
        if (rtEx) {
            conf.setBoolean("multithreaded.runtimeException", true);
        }
        Job job = MapReduceTestUtil.createJob((Configuration)conf, inDir, outDir, 1, 1);
        job.setJobName("mt");
        job.setMapperClass(MultithreadedMapper.class);
        MultithreadedMapper.setMapperClass((Job)job, IDMap.class);
        MultithreadedMapper.setNumberOfThreads((Job)job, (int)2);
        job.setReducerClass(Reducer.class);
        job.waitForCompletion(true);
        if (job.isSuccessful()) {
            Assertions.assertFalse((ioEx || rtEx ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue((ioEx || rtEx ? 1 : 0) != 0);
        }
    }

    public static class IDMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        private boolean ioEx = false;
        private boolean rtEx = false;

        public void setup(Mapper.Context context) {
            this.ioEx = context.getConfiguration().getBoolean("multithreaded.ioException", false);
            this.rtEx = context.getConfiguration().getBoolean("multithreaded.runtimeException", false);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.ioEx) {
                throw new IOException();
            }
            if (this.rtEx) {
                throw new RuntimeException();
            }
            super.map((Object)key, (Object)value, context);
        }
    }
}

