/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.join.CompositeInputFormat;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWrappedRRClassloader {
    @Test
    public void testClassLoader() throws Exception {
        Configuration conf = new Configuration();
        Fake_ClassLoader classLoader = new Fake_ClassLoader();
        conf.setClassLoader((ClassLoader)classLoader);
        Assertions.assertTrue((boolean)(conf.getClassLoader() instanceof Fake_ClassLoader));
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testdir = fs.makeQualified(new Path(System.getProperty("test.build.data", "/tmp")));
        Path base = new Path(testdir, "/empty");
        Path[] src = new Path[]{new Path(base, "i0"), new Path("i1"), new Path("i2")};
        conf.set("mapreduce.join.expr", CompositeInputFormat.compose((String)"outer", IF_ClassLoaderChecker.class, (Path[])src));
        CompositeInputFormat inputFormat = new CompositeInputFormat();
        TaskAttemptID tid = new TaskAttemptID("jt", 1, TaskType.MAP, 0, 0);
        conf.set("mapreduce.task.attempt.id", tid.toString());
        inputFormat.createRecordReader((InputSplit)inputFormat.getSplits((JobContext)Job.getInstance((Configuration)conf)).get(0), (TaskAttemptContext)new TaskAttemptContextImpl(conf, tid));
    }

    public static class Fake_ClassLoader
    extends ClassLoader {
    }

    public static class IF_ClassLoaderChecker<K, V>
    extends MapReduceTestUtil.Fake_IF<K, V> {
        @Override
        public RecordReader<K, V> createRecordReader(InputSplit ignored, TaskAttemptContext context) {
            return new RR_ClassLoaderChecker(context.getConfiguration());
        }
    }

    public static class RR_ClassLoaderChecker<K, V>
    extends MapReduceTestUtil.Fake_RR<K, V> {
        public RR_ClassLoaderChecker(Configuration conf) {
            Assertions.assertTrue((boolean)(conf.getClassLoader() instanceof Fake_ClassLoader), (String)("The class loader has not been inherited from " + CompositeRecordReader.class.getSimpleName()));
        }
    }
}

