/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRKeyValueTextInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestMRKeyValueTextInputFormat.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws Exception {
        Job job = Job.getInstance((Configuration)new Configuration(defaultConf));
        Path file = new Path(workDir, "test.txt");
        int seed = new Random().nextInt();
        LOG.info("seed = " + seed);
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int MAX_LENGTH = 10000;
        for (int length = 0; length < 10000; length += random.nextInt(1000) + 1) {
            LOG.debug("creating; entries = " + length);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(500) + 1;
                LOG.debug("splitting: requesting = " + numSplits);
                List splits = format.getSplits((JobContext)job);
                LOG.debug("splitting: got =        " + splits.size());
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.size(); ++j) {
                    LOG.debug("split[" + j + "]= " + splits.get(j));
                    TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                    RecordReader reader = format.createRecordReader((InputSplit)splits.get(j), context);
                    Class<?> clazz = reader.getClass();
                    Assertions.assertEquals(KeyValueLineRecordReader.class, clazz, (String)"reader class is KeyValueLineRecordReader.");
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(j));
                    reader.initialize((InputSplit)splits.get(j), (TaskAttemptContext)mcontext);
                    Text key = null;
                    Text value = null;
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            key = (Text)reader.getCurrentKey();
                            clazz = key.getClass();
                            Assertions.assertEquals(Text.class, clazz, (String)"Key class is Text.");
                            value = (Text)reader.getCurrentValue();
                            clazz = value.getClass();
                            Assertions.assertEquals(Text.class, clazz, (String)"Value class is Text.");
                            int k = Integer.parseInt(key.toString());
                            int v = Integer.parseInt(value.toString());
                            Assertions.assertEquals((int)0, (int)(k % 2), (String)"Bad key");
                            Assertions.assertEquals((int)(k / 2), (int)v, (String)"Mismatched key/value");
                            LOG.debug("read " + v);
                            Assertions.assertFalse((boolean)bits.get(v), (String)"Key in multiple partitions.");
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug("splits[" + j + "]=" + splits.get(j) + " count=" + count);
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assertions.assertEquals((int)length, (int)bits.cardinality(), (String)"Some keys in no partition.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitableCodecs() throws Exception {
        Job job = Job.getInstance((Configuration)defaultConf);
        Configuration conf = job.getConfiguration();
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName("org.apache.hadoop.io.compress.BZip2Codec"), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        Path file = new Path(workDir, "test" + codec.getDefaultExtension());
        int seed = new Random().nextInt();
        LOG.info("seed = " + seed);
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        int MAX_LENGTH = 500000;
        FileInputFormat.setMaxInputSplitSize((Job)job, (long)25000L);
        for (int length = 0; length < 500000; length += random.nextInt(125000) + 1) {
            LOG.info("creating; entries = " + length);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)localFs.create(file)));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            Assertions.assertTrue((boolean)format.isSplitable((JobContext)job, file), (String)"KVTIF claims not splittable");
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(250) + 1;
                LOG.info("splitting: requesting = " + numSplits);
                List splits = format.getSplits((JobContext)job);
                LOG.info("splitting: got =        " + splits.size());
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.size(); ++j) {
                    LOG.debug("split[" + j + "]= " + splits.get(j));
                    TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                    RecordReader reader = format.createRecordReader((InputSplit)splits.get(j), context);
                    Class<?> clazz = reader.getClass();
                    MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)splits.get(j));
                    reader.initialize((InputSplit)splits.get(j), (TaskAttemptContext)mcontext);
                    Text key = null;
                    Text value = null;
                    try {
                        int count = 0;
                        while (reader.nextKeyValue()) {
                            key = (Text)reader.getCurrentKey();
                            value = (Text)reader.getCurrentValue();
                            int k = Integer.parseInt(key.toString());
                            int v = Integer.parseInt(value.toString());
                            Assertions.assertEquals((int)0, (int)(k % 2), (String)"Bad key");
                            Assertions.assertEquals((int)(k / 2), (int)v, (String)"Mismatched key/value");
                            LOG.debug("read " + k + "," + v);
                            Assertions.assertFalse((boolean)bits.get(v), (String)(k + "," + v + " in multiple partitions."));
                            bits.set(v);
                            ++count;
                        }
                        if (count > 0) {
                            LOG.info("splits[" + j + "]=" + splits.get(j) + " count=" + count);
                            continue;
                        }
                        LOG.debug("splits[" + j + "]=" + splits.get(j) + " count=" + count);
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assertions.assertEquals((int)length, (int)bits.cardinality(), (String)"Some keys in no partition.");
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)), defaultConf);
    }

    @Test
    public void testUTF8() throws Exception {
        LineReader in = this.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        Assertions.assertEquals((Object)"abcd\u20acbdcd\u20ac", (Object)line.toString(), (String)"readLine changed utf8 characters");
        in = this.makeStream("abc\u200axyz");
        in.readLine(line);
        Assertions.assertEquals((Object)"abc\u200axyz", (Object)line.toString(), (String)"split on fake newline");
    }

    @Test
    public void testNewLines() throws Exception {
        LineReader in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
        Text out = new Text();
        in.readLine(out);
        Assertions.assertEquals((int)1, (int)out.getLength(), (String)"line1 length");
        in.readLine(out);
        Assertions.assertEquals((int)2, (int)out.getLength(), (String)"line2 length");
        in.readLine(out);
        Assertions.assertEquals((int)0, (int)out.getLength(), (String)"line3 length");
        in.readLine(out);
        Assertions.assertEquals((int)3, (int)out.getLength(), (String)"line4 length");
        in.readLine(out);
        Assertions.assertEquals((int)4, (int)out.getLength(), (String)"line5 length");
        in.readLine(out);
        Assertions.assertEquals((int)5, (int)out.getLength(), (String)"line5 length");
        Assertions.assertEquals((int)0, (int)in.readLine(out), (String)"end of file");
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, Job job) throws IOException, InterruptedException {
        ArrayList<Text> result = new ArrayList<Text>();
        Configuration conf = job.getConfiguration();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(conf);
        RecordReader reader = format.createRecordReader(split, MapReduceTestUtil.createDummyMapTaskAttemptContext(conf));
        MapContextImpl mcontext = new MapContextImpl(conf, context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
        reader.initialize(split, (TaskAttemptContext)mcontext);
        while (reader.nextKeyValue()) {
            result.add(new Text((Text)reader.getCurrentValue()));
        }
        reader.close();
        return result;
    }

    @Test
    public void testGzip() throws IOException, InterruptedException {
        Configuration conf = new Configuration(defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)conf);
        localFs.delete(workDir, true);
        TestMRKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestMRKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        List splits = format.getSplits((JobContext)job);
        Assertions.assertEquals((int)2, (int)splits.size(), (String)"compressed splits == 2");
        FileSplit tmp = (FileSplit)splits.get(0);
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits.set(0, (InputSplit)splits.get(1));
            splits.set(1, tmp);
        }
        List<Text> results = TestMRKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(0), job);
        Assertions.assertEquals((int)6, (int)results.size(), (String)"splits[0] length");
        Assertions.assertEquals((Object)"the quick", (Object)results.get(0).toString(), (String)"splits[0][0]");
        Assertions.assertEquals((Object)"brown", (Object)results.get(1).toString(), (String)"splits[0][1]");
        Assertions.assertEquals((Object)"fox jumped", (Object)results.get(2).toString(), (String)"splits[0][2]");
        Assertions.assertEquals((Object)"over", (Object)results.get(3).toString(), (String)"splits[0][3]");
        Assertions.assertEquals((Object)" the lazy", (Object)results.get(4).toString(), (String)"splits[0][4]");
        Assertions.assertEquals((Object)" dog", (Object)results.get(5).toString(), (String)"splits[0][5]");
        results = TestMRKeyValueTextInputFormat.readSplit(format, (InputSplit)splits.get(1), job);
        Assertions.assertEquals((int)2, (int)results.size(), (String)"splits[1] length");
        Assertions.assertEquals((Object)"this is a test", (Object)results.get(0).toString(), (String)"splits[1][0]");
        Assertions.assertEquals((Object)"of gzip", (Object)results.get(1).toString(), (String)"splits[1][1]");
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
    }
}

