/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class TestTaskContext
extends HadoopTestCase {
    private static final Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
    private static final Path testRootTempDir = new Path(rootTempDir, "TestTaskContext");
    private static FileSystem fs = null;
    static String myStatus = "my status";
    private static final String INPUT = "Hi\nHi\nHi\nHi\n";
    private static final int INPUT_LINES = "Hi\nHi\nHi\nHi\n".split("\n").length;

    @BeforeAll
    public static void setup() throws Exception {
        fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.delete(testRootTempDir, true);
        fs.mkdirs(testRootTempDir);
    }

    @AfterAll
    public static void cleanup() throws Exception {
        fs.delete(testRootTempDir, true);
    }

    public TestTaskContext() throws IOException {
        super(2, 4, 1, 1);
    }

    @Test
    @Disabled
    public void testContextStatus() throws IOException, InterruptedException, ClassNotFoundException {
        Path test = new Path(testRootTempDir, "testContextStatus");
        int numMaps = 1;
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, 0);
        job.setMapperClass(MyMapper.class);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)"Job failed");
        TaskReport[] reports = job.getTaskReports(TaskType.MAP);
        Assertions.assertEquals((int)numMaps, (int)reports.length);
        Assertions.assertEquals((Object)myStatus, (Object)reports[0].getState());
        int numReduces = 1;
        job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, numReduces);
        job.setMapperClass(MapReduceTestUtil.DataCopyMapper.class);
        job.setReducerClass(MapReduceTestUtil.DataCopyReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(0);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)"Job failed");
    }

    public void testMapContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numMaps = 1;
        Path test = new Path(testRootTempDir, "testMapContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numMaps, 0, INPUT);
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)"Job failed");
    }

    @Test
    public void testReduceContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numTasks = 1;
        Path test = new Path(testRootTempDir, "testReduceContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), new Path(test, "in"), new Path(test, "out"), numTasks, numTasks, INPUT);
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setReducerClass(ProgressCheckerReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(1);
        job.waitForCompletion(true);
        Assertions.assertTrue((boolean)job.isSuccessful(), (String)"Job failed");
    }

    static class MyMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        MyMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException {
            context.setStatus(myStatus);
            Assertions.assertEquals((Object)myStatus, (Object)context.getStatus());
        }
    }

    static class ProgressCheckerMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        private int recordCount = 0;
        private float progressRange = 0.0f;

        ProgressCheckerMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException {
            Assertions.assertEquals((float)0.0f, (float)context.getProgress(), (float)0.0f, (String)"Invalid progress in map setup");
            this.progressRange = context.getNumReduceTasks() == 0 ? 1.0f : 0.667f;
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            float mapPhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedMapProgress = this.progressRange * mapPhaseProgress;
            Assertions.assertEquals((float)weightedMapProgress, (float)context.getProgress(), (float)0.0f, (String)"Invalid progress in map");
            context.write((Object)new Text(value.toString() + this.recordCount), (Object)value);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            Assertions.assertEquals((float)this.progressRange, (float)context.getProgress(), (float)0.0f, (String)"Invalid progress in map cleanup");
        }
    }

    static class ProgressCheckerReducer
    extends Reducer<Text, Text, Text, Text> {
        private int recordCount = 0;
        private final float REDUCE_PROGRESS_RANGE = 0.33333334f;
        private final float SHUFFLE_PROGRESS_RANGE = 0.6666666f;

        ProgressCheckerReducer() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            float reducePhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedReducePhaseProgress = 0.33333334f * reducePhaseProgress;
            Assertions.assertEquals((float)(0.6666666f + weightedReducePhaseProgress), (float)context.getProgress(), (float)0.01f, (String)"Invalid progress in reduce setup");
        }

        public void reduce(Text key, Iterator<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            float reducePhaseProgress = (float)(++this.recordCount) / (float)INPUT_LINES;
            float weightedReducePhaseProgress = 0.33333334f * reducePhaseProgress;
            Assertions.assertEquals((float)(0.6666666f + weightedReducePhaseProgress), (float)context.getProgress(), (float)0.01f, (String)"Invalid progress in reduce");
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Assertions.assertEquals((float)1.0f, (float)context.getProgress(), (float)0.0f, (String)"Invalid progress in reduce cleanup");
        }
    }
}

