/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Random;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;
import org.apache.hadoop.mapreduce.counters.Limits;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCounters {
    static final Logger LOG = LoggerFactory.getLogger(TestCounters.class);
    static final Enum<?> FRAMEWORK_COUNTER = TaskCounter.CPU_MILLISECONDS;
    static final long FRAMEWORK_COUNTER_VALUE = 8L;
    static final String FS_SCHEME = "HDFS";
    static final FileSystemCounter FS_COUNTER = FileSystemCounter.BYTES_READ;
    static final long FS_COUNTER_VALUE = 10L;

    @Test
    public void testCounterValue() {
        int NUMBER_TESTS = 100;
        int NUMBER_INC = 10;
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            long initValue;
            long expectedValue = initValue = (long)rand.nextInt();
            Counter counter = new Counters().findCounter("test", "foo");
            counter.setValue(initValue);
            Assertions.assertEquals((long)expectedValue, (long)counter.getValue(), (String)"Counter value is not initialized correctly");
            for (int j = 0; j < 10; ++j) {
                int incValue = rand.nextInt();
                counter.increment((long)incValue);
                Assertions.assertEquals((long)(expectedValue += (long)incValue), (long)counter.getValue(), (String)"Counter value is not incremented correctly");
            }
            expectedValue = rand.nextInt();
            counter.setValue(expectedValue);
            Assertions.assertEquals((long)expectedValue, (long)counter.getValue(), (String)"Counter value is not set correctly");
        }
    }

    @Test
    public void testLimits() {
        for (int i = 0; i < 3; ++i) {
            this.testMaxCounters(new Counters());
            this.testMaxGroups(new Counters());
        }
    }

    @Test
    public void testCountersIncrement() {
        Counters fCounters = new Counters();
        Counter fCounter = fCounters.findCounter(FRAMEWORK_COUNTER);
        fCounter.setValue(100L);
        Counter gCounter = fCounters.findCounter("test", "foo");
        gCounter.setValue(200L);
        Counters counters = new Counters();
        counters.incrAllCounters((AbstractCounters)fCounters);
        for (CounterGroup cg : fCounters) {
            Counter counter;
            CounterGroup group = (CounterGroup)counters.getGroup(cg.getName());
            if (group.getName().equals("test")) {
                counter = counters.findCounter("test", "foo");
                Assertions.assertEquals((long)200L, (long)counter.getValue());
                continue;
            }
            counter = counters.findCounter(FRAMEWORK_COUNTER);
            Assertions.assertEquals((long)100L, (long)counter.getValue());
        }
    }

    private void testMaxCounters(final Counters counters) {
        LOG.info("counters max=" + Limits.getCountersMax());
        for (int i = 0; i < Limits.getCountersMax(); ++i) {
            counters.findCounter("test", "test" + i);
        }
        this.setExpected(counters);
        this.shouldThrow(LimitExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("test", "bad");
            }
        });
        this.checkExpected(counters);
    }

    private void testMaxGroups(final Counters counters) {
        LOG.info("counter groups max=" + Limits.getGroupsMax());
        for (int i = 0; i < Limits.getGroupsMax(); ++i) {
            counters.findCounter("test" + i, "test");
        }
        this.setExpected(counters);
        this.shouldThrow(LimitExceededException.class, new Runnable(){

            @Override
            public void run() {
                counters.findCounter("bad", "test");
            }
        });
        this.checkExpected(counters);
    }

    private void setExpected(Counters counters) {
        counters.findCounter(FRAMEWORK_COUNTER).setValue(8L);
        counters.findCounter(FS_SCHEME, FS_COUNTER).setValue(10L);
    }

    private void checkExpected(Counters counters) {
        Assertions.assertEquals((long)8L, (long)counters.findCounter(FRAMEWORK_COUNTER).getValue());
        Assertions.assertEquals((long)10L, (long)counters.findCounter(FS_SCHEME, FS_COUNTER).getValue());
    }

    private void shouldThrow(Class<? extends Exception> ecls, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            Assertions.assertSame(ecls, e.getClass());
            LOG.info("got expected: " + e);
            return;
        }
        Assertions.assertTrue((boolean)false, (String)("Should've thrown " + ecls.getSimpleName()));
    }
}

