/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FailJob
extends Configured
implements Tool {
    public static String FAIL_MAP = "mapreduce.failjob.map.fail";
    public static String FAIL_REDUCE = "mapreduce.failjob.reduce.fail";

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new FailJob(), (String[])args);
        System.exit(res);
    }

    public Job createJob(boolean failMappers, boolean failReducers, Path inputFile) throws IOException {
        Configuration conf = this.getConf();
        conf.setBoolean(FAIL_MAP, failMappers);
        conf.setBoolean(FAIL_REDUCE, failReducers);
        Job job = Job.getInstance((Configuration)conf, (String)"fail");
        job.setJarByClass(FailJob.class);
        job.setMapperClass(FailMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(FailReducer.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setSpeculativeExecution(false);
        job.setJobName("Fail job");
        FileInputFormat.addInputPath((Job)job, (Path)inputFile);
        return job;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("FailJob  (-failMappers|-failReducers)");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 2;
        }
        boolean failMappers = false;
        boolean failReducers = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-failMappers")) {
                failMappers = true;
                continue;
            }
            if (!args[i].equals("-failReducers")) continue;
            failReducers = true;
        }
        if (!(failMappers ^ failReducers)) {
            System.err.println("Exactly one of -failMappers or -failReducers must be specified.");
            return 3;
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path inputDir = new Path(FailJob.class.getSimpleName() + "_in");
        fs.mkdirs(inputDir);
        for (int i = 0; i < this.getConf().getInt("mapred.map.tasks", 1); ++i) {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, Integer.toString(i)))));
            w.write(Integer.toString(i) + "\n");
            w.close();
        }
        Job job = this.createJob(failMappers, failReducers, inputDir);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class FailMapper
    extends Mapper<LongWritable, Text, LongWritable, NullWritable> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (context.getConfiguration().getBoolean(FAIL_MAP, true)) {
                throw new RuntimeException("Intentional map failure");
            }
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static class FailReducer
    extends Reducer<LongWritable, NullWritable, NullWritable, NullWritable> {
        public void reduce(LongWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException {
            if (context.getConfiguration().getBoolean(FAIL_REDUCE, false)) {
                throw new RuntimeException("Intentional reduce failure");
            }
            context.setStatus("No worries");
        }
    }
}

