/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.db;

import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.hadoop.mapred.lib.db.DBOutputFormat;
import org.apache.hadoop.mapred.lib.db.DBWritable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConstructQuery {
    private String[] fieldNames = new String[]{"id", "name", "value"};
    private String[] nullFieldNames = new String[]{null, null, null};
    private String expected = "INSERT INTO hadoop_output (id,name,value) VALUES (?,?,?);";
    private String nullExpected = "INSERT INTO hadoop_output VALUES (?,?,?);";
    private DBOutputFormat<DBWritable, NullWritable> format = new DBOutputFormat();

    @Test
    public void testConstructQuery() {
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        Assertions.assertEquals((Object)this.expected, (Object)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        Assertions.assertEquals((Object)this.nullExpected, (Object)actual);
    }

    @Test
    public void testSetOutput() throws IOException {
        JobConf job = new JobConf();
        DBOutputFormat.setOutput((JobConf)job, (String)"hadoop_output", (String[])this.fieldNames);
        DBConfiguration dbConf = new DBConfiguration(job);
        String actual = this.format.constructQuery(dbConf.getOutputTableName(), dbConf.getOutputFieldNames());
        Assertions.assertEquals((Object)this.expected, (Object)actual);
        job = new JobConf();
        dbConf = new DBConfiguration(job);
        DBOutputFormat.setOutput((JobConf)job, (String)"hadoop_output", (int)this.nullFieldNames.length);
        Assertions.assertNull((Object)dbConf.getOutputFieldNames());
        Assertions.assertEquals((int)this.nullFieldNames.length, (int)dbConf.getOutputFieldCount());
        actual = this.format.constructQuery(dbConf.getOutputTableName(), new String[dbConf.getOutputFieldCount()]);
        Assertions.assertEquals((Object)this.nullExpected, (Object)actual);
    }
}

