/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib.aggregate;

import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAggregates {
    private static NumberFormat idFormat = NumberFormat.getInstance();

    @Test
    public void testAggregates() throws Exception {
        TestAggregates.launch();
    }

    public static void launch() throws Exception {
        JobConf conf = new JobConf(TestAggregates.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numOfInputLines = 20;
        String baseDir = System.getProperty("test.build.data", "build/test/data");
        Path OUTPUT_DIR = new Path(baseDir + "/output_for_aggregates_test");
        Path INPUT_DIR = new Path(baseDir + "/input_for_aggregates_test");
        String inputFile = "input.txt";
        fs.delete(INPUT_DIR, true);
        fs.mkdirs(INPUT_DIR);
        fs.delete(OUTPUT_DIR, true);
        StringBuilder inputData = new StringBuilder();
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append("max\t19\n");
        expectedOutput.append("min\t1\n");
        FSDataOutputStream fileOut = fs.create(new Path(INPUT_DIR, inputFile));
        for (int i = 1; i < numOfInputLines; ++i) {
            expectedOutput.append("count_").append(idFormat.format(i));
            expectedOutput.append("\t").append(i).append("\n");
            inputData.append(idFormat.format(i));
            for (int j = 1; j < i; ++j) {
                inputData.append(" ").append(idFormat.format(i));
            }
            inputData.append("\n");
        }
        expectedOutput.append("value_as_string_max\t9\n");
        expectedOutput.append("value_as_string_min\t1\n");
        expectedOutput.append("uniq_count\t15\n");
        fileOut.write(inputData.toString().getBytes(StandardCharsets.UTF_8));
        fileOut.close();
        System.out.println("inputData:");
        System.out.println(inputData.toString());
        JobConf job = new JobConf((Configuration)conf, TestAggregates.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        job.setInputFormat(TextInputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)OUTPUT_DIR);
        job.setOutputFormat(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(1);
        job.setMapperClass(ValueAggregatorMapper.class);
        job.setReducerClass(ValueAggregatorReducer.class);
        job.setCombinerClass(ValueAggregatorCombiner.class);
        job.setInt("aggregator.descriptor.num", 1);
        job.set("aggregator.descriptor.0", "UserDefined,org.apache.hadoop.mapred.lib.aggregate.AggregatorTests");
        job.setLong("aggregate.max.num.unique.values", 14L);
        JobClient.runJob((JobConf)job);
        boolean success = true;
        Path outPath = new Path(OUTPUT_DIR, "part-00000");
        String outdata = MapReduceTestUtil.readOutput(outPath, (Configuration)job);
        System.out.println("full out data:");
        System.out.println(outdata.toString());
        outdata = outdata.substring(0, expectedOutput.toString().length());
        Assertions.assertEquals((Object)expectedOutput.toString(), (Object)outdata);
        fs.delete(OUTPUT_DIR, true);
        fs.delete(INPUT_DIR, true);
    }

    public static void main(String[] argv) throws Exception {
        TestAggregates.launch();
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }
}

