/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.DelegatingInputFormat;
import org.apache.hadoop.mapred.lib.MultipleInputs;
import org.apache.hadoop.mapred.lib.TaggedInputSplit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDelegatingInputFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitting() throws Exception {
        JobConf conf = new JobConf();
        MiniDFSCluster dfs = null;
        try {
            dfs = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).racks(new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}).hosts(new String[]{"host0", "host1", "host2", "host3"}).build();
            DistributedFileSystem fs = dfs.getFileSystem();
            Path path = TestDelegatingInputFormat.getPath("/foo/bar", (FileSystem)fs);
            Path path2 = TestDelegatingInputFormat.getPath("/foo/baz", (FileSystem)fs);
            Path path3 = TestDelegatingInputFormat.getPath("/bar/bar", (FileSystem)fs);
            Path path4 = TestDelegatingInputFormat.getPath("/bar/baz", (FileSystem)fs);
            int numSplits = 100;
            MultipleInputs.addInputPath((JobConf)conf, (Path)path, TextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path2, TextInputFormat.class, MapClass2.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path3, KeyValueTextInputFormat.class, MapClass.class);
            MultipleInputs.addInputPath((JobConf)conf, (Path)path4, TextInputFormat.class, MapClass2.class);
            DelegatingInputFormat inFormat = new DelegatingInputFormat();
            InputSplit[] splits = inFormat.getSplits(conf, 100);
            int[] bins = new int[3];
            for (InputSplit split : splits) {
                Assertions.assertTrue((boolean)(split instanceof TaggedInputSplit));
                TaggedInputSplit tis = (TaggedInputSplit)split;
                int index = -1;
                index = tis.getInputFormatClass().equals(KeyValueTextInputFormat.class) ? 0 : (tis.getMapperClass().equals(MapClass.class) ? 1 : 2);
                int n = index;
                bins[n] = bins[n] + 1;
            }
            for (int count : bins) {
                Assertions.assertEquals((int)100, (int)count);
            }
            Assertions.assertTrue((boolean)true);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }

    static Path getPath(String location, FileSystem fs) throws IOException {
        Path path = new Path(location);
        FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        return path;
    }

    static class MapClass
    implements Mapper<String, String, String, String> {
        MapClass() {
        }

        public void map(String key, String value, OutputCollector<String, String> output, Reporter reporter) throws IOException {
        }

        public void configure(JobConf job) {
        }

        public void close() throws IOException {
        }
    }

    static class MapClass2
    extends MapClass {
        MapClass2() {
        }
    }
}

