/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.TestJobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timelineservice.collector.PerNodeTimelineCollectorsAuxService;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMRTimelineEventHandling {
    private static final String TIMELINE_AUX_SERVICE_NAME = "timeline_collector";
    private static final Logger LOG = LoggerFactory.getLogger(TestMRTimelineEventHandling.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimelineServiceStartInMiniCluster() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", false);
        conf.setBoolean("mapreduce.job.emit-timeline-data", true);
        MiniMRYarnCluster cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestMRTimelineEventHandling.class.getSimpleName(), 1);
            cluster.init((Configuration)conf);
            cluster.start();
            Assertions.assertNull((Object)cluster.getApplicationHistoryServer(), (String)"Timeline Service should not have been started");
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
        conf.setBoolean("yarn.timeline-service.enabled", false);
        conf.setBoolean("mapreduce.job.emit-timeline-data", false);
        cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1);
            cluster.init((Configuration)conf);
            cluster.start();
            Assertions.assertNull((Object)cluster.getApplicationHistoryServer(), (String)"Timeline Service should not have been started");
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMRTimelineEventHandling() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("mapreduce.job.emit-timeline-data", true);
        MiniMRYarnCluster cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestMRTimelineEventHandling.class.getSimpleName(), 1);
            cluster.init((Configuration)conf);
            cluster.start();
            conf.set("yarn.timeline-service.webapp.address", MiniYARNCluster.getHostname() + ":" + cluster.getApplicationHistoryServer().getPort());
            TimelineStore ts = cluster.getApplicationHistoryServer().getTimelineStore();
            String localPathRoot = System.getProperty("test.build.data", "build/test/data");
            Path inDir = new Path(localPathRoot, "input");
            Path outDir = new Path(localPathRoot, "output");
            RunningJob job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
            Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
            TimelineEntities entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assertions.assertEquals((int)1, (int)entities.getEntities().size());
            TimelineEntity tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assertions.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
            Assertions.assertEquals((Object)"MAPREDUCE_JOB", (Object)tEntity.getEntityType());
            Assertions.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((org.apache.hadoop.yarn.api.records.timeline.TimelineEvent)tEntity.getEvents().get(tEntity.getEvents().size() - 1)).getEventType());
            Assertions.assertEquals((Object)EventType.JOB_FINISHED.toString(), (Object)((org.apache.hadoop.yarn.api.records.timeline.TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            job = UtilsForTests.runJobFail(new JobConf((Configuration)conf), inDir, outDir);
            Assertions.assertEquals((int)JobStatus.FAILED, (int)job.getJobStatus().getState().getValue());
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assertions.assertEquals((int)2, (int)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assertions.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
            Assertions.assertEquals((Object)"MAPREDUCE_JOB", (Object)tEntity.getEntityType());
            Assertions.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((org.apache.hadoop.yarn.api.records.timeline.TimelineEvent)tEntity.getEvents().get(tEntity.getEvents().size() - 1)).getEventType());
            Assertions.assertEquals((Object)EventType.JOB_FAILED.toString(), (Object)((org.apache.hadoop.yarn.api.records.timeline.TimelineEvent)tEntity.getEvents().get(0)).getEventType());
        }
        finally {
            if (cluster != null) {
                cluster.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMRNewTimelineServiceEventHandling() throws Exception {
        LOG.info("testMRNewTimelineServiceEventHandling start.");
        String testDir = new File("target", this.getClass().getSimpleName() + "-test_dir").getAbsolutePath();
        String storageDir = testDir + File.separator + "timeline_service_data";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        conf.setBoolean("mapreduce.job.emit-timeline-data", true);
        conf.set("yarn.timeline-service.fs-writer.root-dir", storageDir);
        conf.set("yarn.nodemanager.aux-services", TIMELINE_AUX_SERVICE_NAME);
        conf.set("yarn.nodemanager.aux-services.timeline_collector.class", PerNodeTimelineCollectorsAuxService.class.getName());
        conf.setBoolean("yarn.system-metrics-publisher.enabled", true);
        MiniMRYarnCluster cluster = null;
        try {
            cluster = new MiniMRYarnCluster(TestMRTimelineEventHandling.class.getSimpleName(), 1, true);
            cluster.init((Configuration)conf);
            cluster.start();
            LOG.info("A MiniMRYarnCluster get start.");
            Path inDir = new Path(testDir, "input");
            Path outDir = new Path(testDir, "output");
            LOG.info("Run 1st job which should be successful.");
            JobConf successConf = new JobConf((Configuration)conf);
            successConf.set("dummy_conf1", UtilsForTests.createConfigValue(52224));
            successConf.set("dummy_conf2", UtilsForTests.createConfigValue(52224));
            successConf.set("huge_dummy_conf1", UtilsForTests.createConfigValue(103424));
            successConf.set("huge_dummy_conf2", UtilsForTests.createConfigValue(103424));
            RunningJob job = UtilsForTests.runJobSucceed(successConf, inDir, outDir);
            Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
            YarnClient yarnClient = YarnClient.createYarnClient();
            yarnClient.init(new Configuration(cluster.getConfig()));
            yarnClient.start();
            EnumSet<YarnApplicationState> appStates = EnumSet.allOf(YarnApplicationState.class);
            ApplicationId firstAppId = null;
            List apps = yarnClient.getApplications(appStates);
            Assertions.assertEquals((int)apps.size(), (int)1);
            ApplicationReport appReport = (ApplicationReport)apps.get(0);
            firstAppId = appReport.getApplicationId();
            UtilsForTests.waitForAppFinished(job, cluster);
            this.checkNewTimelineEvent(firstAppId, appReport, storageDir);
            LOG.info("Run 2nd job which should be failed.");
            job = UtilsForTests.runJobFail(new JobConf((Configuration)conf), inDir, outDir);
            Assertions.assertEquals((int)JobStatus.FAILED, (int)job.getJobStatus().getState().getValue());
            apps = yarnClient.getApplications(appStates);
            Assertions.assertEquals((int)apps.size(), (int)2);
            appReport = ((ApplicationReport)apps.get(0)).getApplicationId().equals((Object)firstAppId) ? (ApplicationReport)apps.get(0) : (ApplicationReport)apps.get(1);
            this.checkNewTimelineEvent(firstAppId, appReport, storageDir);
        }
        finally {
            File testDirFolder;
            if (cluster != null) {
                cluster.stop();
            }
            if ((testDirFolder = new File(testDir)).isDirectory()) {
                FileUtils.deleteDirectory((File)testDirFolder);
            }
        }
    }

    private void checkNewTimelineEvent(ApplicationId appId, ApplicationReport appReport, String storageDir) throws IOException {
        String tmpRoot = storageDir + File.separator + "entities" + File.separator;
        File tmpRootFolder = new File(tmpRoot);
        Assertions.assertTrue((boolean)tmpRootFolder.isDirectory());
        String basePath = tmpRoot + "yarn_cluster" + File.separator + UserGroupInformation.getCurrentUser().getShortUserName() + File.separator + appReport.getName() + File.separator + "1" + File.separator + appReport.getStartTime() + File.separator + appId.toString();
        String outputDirJob = basePath + File.separator + "MAPREDUCE_JOB" + File.separator;
        File entityFolder = new File(outputDirJob);
        Assertions.assertTrue((boolean)entityFolder.isDirectory(), (String)("Job output directory: " + outputDirJob + " does not exist."));
        String jobEventFileName = appId.toString().replaceAll("application", "job") + ".thist";
        String jobEventFilePath = outputDirJob + jobEventFileName;
        File jobEventFile = new File(jobEventFilePath);
        Assertions.assertTrue((boolean)jobEventFile.exists(), (String)("jobEventFilePath: " + jobEventFilePath + " does not exist."));
        this.verifyEntity(jobEventFile, EventType.JOB_FINISHED.name(), true, false, null, false);
        HashSet cfgsToCheck = Sets.newHashSet((Object[])new String[]{"dummy_conf1", "dummy_conf2", "huge_dummy_conf1", "huge_dummy_conf2"});
        this.verifyEntity(jobEventFile, null, false, true, cfgsToCheck, false);
        String outputAppDir = basePath + File.separator + "YARN_APPLICATION" + File.separator;
        entityFolder = new File(outputAppDir);
        Assertions.assertTrue((boolean)entityFolder.isDirectory(), (String)("Job output directory: " + outputAppDir + " does not exist."));
        String appEventFileName = appId.toString() + ".thist";
        String appEventFilePath = outputAppDir + appEventFileName;
        File appEventFile = new File(appEventFilePath);
        Assertions.assertTrue((boolean)appEventFile.exists(), (String)("appEventFilePath: " + appEventFilePath + " does not exist."));
        this.verifyEntity(appEventFile, null, true, false, null, false);
        this.verifyEntity(appEventFile, null, false, true, cfgsToCheck, false);
        String outputDirTask = basePath + File.separator + "MAPREDUCE_TASK" + File.separator;
        File taskFolder = new File(outputDirTask);
        Assertions.assertTrue((boolean)taskFolder.isDirectory(), (String)("Task output directory: " + outputDirTask + " does not exist."));
        String taskEventFileName = appId.toString().replaceAll("application", "task") + "_m_000000.thist";
        String taskEventFilePath = outputDirTask + taskEventFileName;
        File taskEventFile = new File(taskEventFilePath);
        Assertions.assertTrue((boolean)taskEventFile.exists(), (String)("taskEventFileName: " + taskEventFilePath + " does not exist."));
        this.verifyEntity(taskEventFile, EventType.TASK_FINISHED.name(), true, false, null, true);
        String outputDirTaskAttempt = basePath + File.separator + "MAPREDUCE_TASK_ATTEMPT" + File.separator;
        File taskAttemptFolder = new File(outputDirTaskAttempt);
        Assertions.assertTrue((boolean)taskAttemptFolder.isDirectory(), (String)("TaskAttempt output directory: " + outputDirTaskAttempt + " does not exist."));
        String taskAttemptEventFileName = appId.toString().replaceAll("application", "attempt") + "_m_000000_0.thist";
        String taskAttemptEventFilePath = outputDirTaskAttempt + taskAttemptEventFileName;
        File taskAttemptEventFile = new File(taskAttemptEventFilePath);
        Assertions.assertTrue((boolean)taskAttemptEventFile.exists(), (String)("taskAttemptEventFileName: " + taskAttemptEventFilePath + " does not exist."));
        this.verifyEntity(taskAttemptEventFile, EventType.MAP_ATTEMPT_FINISHED.name(), true, false, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyEntity(File entityFile, String eventId, boolean chkMetrics, boolean chkCfg, Set<String> cfgsToVerify, boolean checkIdPrefix) throws IOException {
        try (BufferedReader reader = null;){
            String strLine;
            reader = new BufferedReader(new FileReader(entityFile));
            long idPrefix = -1L;
            while ((strLine = reader.readLine()) != null) {
                if (strLine.trim().length() <= 0) continue;
                org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = (org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity)FileSystemTimelineReaderImpl.getTimelineRecordFromJSON((String)strLine.trim(), org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity.class);
                LOG.info("strLine.trim()= " + strLine.trim());
                if (checkIdPrefix) {
                    Assertions.assertTrue((entity.getIdPrefix() > 0L ? 1 : 0) != 0, (String)"Entity ID prefix expected to be > 0");
                    if (idPrefix == -1L) {
                        idPrefix = entity.getIdPrefix();
                    } else {
                        Assertions.assertEquals((long)idPrefix, (long)entity.getIdPrefix(), (String)"Entity ID prefix should be same across each publish of same entity");
                    }
                }
                if (eventId == null) {
                    if (chkMetrics && entity.getMetrics().size() > 0) {
                        return;
                    }
                    if (!chkCfg || entity.getConfigs().size() <= 0) continue;
                    if (cfgsToVerify == null) {
                        return;
                    }
                    Iterator<String> itr = cfgsToVerify.iterator();
                    while (itr.hasNext()) {
                        String config = itr.next();
                        if (!entity.getConfigs().containsKey(config)) continue;
                        itr.remove();
                    }
                    if (!cfgsToVerify.isEmpty()) continue;
                    return;
                }
                for (TimelineEvent event : entity.getEvents()) {
                    if (!event.getId().equals(eventId)) continue;
                    if (chkMetrics) {
                        Assertions.assertTrue((entity.getMetrics().size() > 0 ? 1 : 0) != 0);
                    }
                    if (chkCfg) {
                        Assertions.assertTrue((entity.getConfigs().size() > 0 ? 1 : 0) != 0);
                        if (cfgsToVerify != null) {
                            for (String cfg : cfgsToVerify) {
                                Assertions.assertTrue((boolean)entity.getConfigs().containsKey(cfg));
                            }
                        }
                    }
                    return;
                }
            }
            if (cfgsToVerify != null) {
                Assertions.assertTrue((boolean)cfgsToVerify.isEmpty());
                return;
            }
            Assertions.fail((String)("Expected event : " + eventId + " not found in the file " + entityFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testMapreduceJobTimelineServiceEnabled() throws Exception {
        Path outDir;
        Path inDir;
        FileSystem fs;
        block8: {
            TimelineEntity tEntity;
            TimelineEntities entities;
            RunningJob job;
            TimelineStore ts;
            MiniMRYarnCluster cluster;
            YarnConfiguration conf;
            block7: {
                conf = new YarnConfiguration();
                conf.setBoolean("yarn.timeline-service.enabled", true);
                conf.setBoolean("mapreduce.job.emit-timeline-data", false);
                cluster = null;
                fs = null;
                inDir = new Path(GenericTestUtils.getTempPath((String)"input"));
                outDir = new Path(GenericTestUtils.getTempPath((String)"output"));
                try {
                    fs = FileSystem.get((Configuration)conf);
                    cluster = new MiniMRYarnCluster(TestMRTimelineEventHandling.class.getSimpleName(), 1);
                    cluster.init((Configuration)conf);
                    cluster.start();
                    conf.set("yarn.timeline-service.webapp.address", MiniYARNCluster.getHostname() + ":" + cluster.getApplicationHistoryServer().getPort());
                    ts = cluster.getApplicationHistoryServer().getTimelineStore();
                    job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
                    Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
                    entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
                    Assertions.assertEquals((int)0, (int)entities.getEntities().size());
                    conf.setBoolean("mapreduce.job.emit-timeline-data", true);
                    job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
                    Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
                    entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
                    Assertions.assertEquals((int)1, (int)entities.getEntities().size());
                    tEntity = (TimelineEntity)entities.getEntities().get(0);
                    Assertions.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
                    if (cluster == null) break block7;
                }
                catch (Throwable throwable) {
                    if (cluster != null) {
                        cluster.stop();
                    }
                    this.deletePaths(fs, inDir, outDir);
                    throw throwable;
                }
                cluster.stop();
            }
            this.deletePaths(fs, inDir, outDir);
            conf = new YarnConfiguration();
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setBoolean("mapreduce.job.emit-timeline-data", true);
            cluster = null;
            try {
                cluster = new MiniMRYarnCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1);
                cluster.init((Configuration)conf);
                cluster.start();
                conf.set("yarn.timeline-service.webapp.address", MiniYARNCluster.getHostname() + ":" + cluster.getApplicationHistoryServer().getPort());
                ts = cluster.getApplicationHistoryServer().getTimelineStore();
                conf.setBoolean("mapreduce.job.emit-timeline-data", false);
                job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
                Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
                entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
                Assertions.assertEquals((int)0, (int)entities.getEntities().size());
                conf.setBoolean("mapreduce.job.emit-timeline-data", true);
                job = UtilsForTests.runJobSucceed(new JobConf((Configuration)conf), inDir, outDir);
                Assertions.assertEquals((int)JobStatus.SUCCEEDED, (int)job.getJobStatus().getState().getValue());
                entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
                Assertions.assertEquals((int)1, (int)entities.getEntities().size());
                tEntity = (TimelineEntity)entities.getEntities().get(0);
                Assertions.assertEquals((Object)job.getID().toString(), (Object)tEntity.getEntityId());
                if (cluster != null) {
                }
                break block8;
            }
            catch (Throwable throwable) {
                if (cluster != null) {
                    cluster.stop();
                }
                this.deletePaths(fs, inDir, outDir);
                throw throwable;
            }
            cluster.stop();
        }
        this.deletePaths(fs, inDir, outDir);
    }

    private void deletePaths(FileSystem fs, Path ... paths) {
        if (fs == null) {
            return;
        }
        for (Path path : paths) {
            try {
                fs.delete(path, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

