/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.security.IntermediateEncryptedStream;
import org.apache.hadoop.mapreduce.security.SpillCallBackInjector;
import org.apache.hadoop.mapreduce.security.SpillCallBackPathsFinder;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalJobSubmission {
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalJobSubmission.class);
    private static File testRootDir;
    private File unitTestDir;
    private Path jarPath;
    private Configuration config;

    @BeforeAll
    public static void setupClass() throws Exception {
        testRootDir = GenericTestUtils.setupTestRootDir(TestLocalJobSubmission.class);
    }

    @BeforeEach
    public void setup(TestInfo testInfo) throws IOException {
        this.unitTestDir = new File(testRootDir, testInfo.getDisplayName());
        this.unitTestDir.mkdirs();
        this.config = this.createConfig();
        this.jarPath = this.makeJar(new Path(this.unitTestDir.getAbsolutePath(), "test.jar"));
    }

    private Configuration createConfig() {
        Configuration conf = MRJobConfUtil.setLocalDirectoriesConfigForTesting(null, (File)this.unitTestDir);
        conf.set("mapreduce.framework.name", "local");
        return conf;
    }

    @Test
    public void testLocalJobLibjarsOption() throws IOException {
        this.testLocalJobLibjarsOption(this.config);
        this.config.setBoolean("mapreduce.client.libjars.wildcard", false);
        this.testLocalJobLibjarsOption(this.config);
    }

    private void testLocalJobLibjarsOption(Configuration conf) throws IOException {
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("mapreduce.framework.name", "local");
        String[] args = new String[]{"-jt", "local", "-libjars", this.jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            LOG.error("Job failed with {}", (Object)e.getLocalizedMessage(), (Object)e);
            Assertions.fail((String)"Job failed");
        }
        Assertions.assertEquals((int)0, (int)res, (String)"dist job res is not 0:");
    }

    @Test
    public void testLocalJobEncryptedIntermediateData() throws IOException {
        this.config = MRJobConfUtil.initEncryptedIntermediateConfigsForTesting((Configuration)this.config);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            SpillCallBackPathsFinder spillInjector = (SpillCallBackPathsFinder)IntermediateEncryptedStream.setSpillCBInjector((SpillCallBackInjector)new SpillCallBackPathsFinder());
            res = ToolRunner.run((Configuration)this.config, (Tool)new SleepJob(), (String[])args);
            Assertions.assertTrue((spillInjector.getEncryptedSpilledFiles().size() > 0 ? 1 : 0) != 0, (String)"No spill occurred");
        }
        catch (Exception e) {
            LOG.error("Job failed with {}", (Object)e.getLocalizedMessage(), (Object)e);
            Assertions.fail((String)"Job failed");
        }
        Assertions.assertEquals((int)0, (int)res, (String)"dist job res is not 0:");
    }

    @Test
    public void testJobMaxMapConfig() throws Exception {
        this.config.setInt("mapreduce.job.max.map", 0);
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)this.config, (Tool)new SleepJob(), (String[])args);
            Assertions.fail((String)"Job should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getLocalizedMessage().contains("The number of map tasks 1 exceeded limit"));
        }
    }

    @Test
    public void testLocalJobFilesOption() throws IOException {
        this.config.set("fs.defaultFS", "hdfs://localhost:9000");
        String[] args = new String[]{"-jt", "local", "-files", this.jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)this.config, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            LOG.error("Job failed with {}", (Object)e.getLocalizedMessage(), (Object)e);
            Assertions.fail((String)"Job failed");
        }
        Assertions.assertEquals((int)0, (int)res, (String)"dist job res is not 0:");
    }

    @Test
    public void testLocalJobArchivesOption() throws IOException {
        this.config.set("fs.defaultFS", "hdfs://localhost:9000");
        String[] args = new String[]{"-jt", "local", "-archives", this.jarPath.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)this.config, (Tool)new SleepJob(), (String[])args);
        }
        catch (Exception e) {
            LOG.error("Job failed with {}" + e.getLocalizedMessage(), (Throwable)e);
            Assertions.fail((String)"Job failed");
        }
        Assertions.assertEquals((int)0, (int)res, (String)"dist job res is not 0:");
    }

    private Path makeJar(Path p) throws IOException {
        FileOutputStream fos = new FileOutputStream(p.toString());
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("test.jar.inside");
        jos.putNextEntry(ze);
        jos.write("inside the jar!".getBytes());
        jos.closeEntry();
        jos.close();
        return p;
    }
}

