/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.AppendOp;
import org.apache.hadoop.fs.slive.ArgumentParser;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.ConfigMerger;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.CreateOp;
import org.apache.hadoop.fs.slive.DataVerifier;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.DeleteOp;
import org.apache.hadoop.fs.slive.ListOp;
import org.apache.hadoop.fs.slive.MkdirOp;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.OperationWeight;
import org.apache.hadoop.fs.slive.PathFinder;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.ReadOp;
import org.apache.hadoop.fs.slive.RenameOp;
import org.apache.hadoop.fs.slive.RouletteSelector;
import org.apache.hadoop.fs.slive.SleepOp;
import org.apache.hadoop.fs.slive.SliveTest;
import org.apache.hadoop.fs.slive.TruncateOp;
import org.apache.hadoop.fs.slive.WeightSelector;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlive {
    private static final Logger LOG = LoggerFactory.getLogger(TestSlive.class);
    private static final Random rnd = new Random(1L);
    private static final String TEST_DATA_PROP = "test.build.data";

    private static Configuration getBaseConfig() {
        Configuration conf = new Configuration();
        return conf;
    }

    private static File getWriteLoc() {
        String writeLoc = System.getProperty(TEST_DATA_PROP, "build/test/data/");
        File writeDir = new File(writeLoc, "slive");
        writeDir.mkdirs();
        return writeDir;
    }

    private static File getFlowLocation() {
        return new File(TestSlive.getWriteLoc(), "flow");
    }

    private static File getTestDir() {
        return new File(TestSlive.getWriteLoc(), "slivedir");
    }

    private static File getTestFile() {
        return new File(TestSlive.getWriteLoc(), "slivefile");
    }

    private static File getTestRenameFile() {
        return new File(TestSlive.getWriteLoc(), "slivefile1");
    }

    private static File getResultFile() {
        return new File(TestSlive.getWriteLoc(), "sliveresfile");
    }

    private static File getImaginaryFile() {
        return new File(TestSlive.getWriteLoc(), "slivenofile");
    }

    private String[] getTestArgs(boolean sleep) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add("-" + ConfigOption.WRITE_SIZE.getOpt());
        args.add("1M,2M");
        args.add("-" + ConfigOption.OPS.getOpt());
        args.add("" + Constants.OperationType.values().length);
        args.add("-" + ConfigOption.MAPS.getOpt());
        args.add("2");
        args.add("-" + ConfigOption.REDUCES.getOpt());
        args.add("2");
        args.add("-" + ConfigOption.APPEND_SIZE.getOpt());
        args.add("1M,2M");
        args.add("-" + ConfigOption.BLOCK_SIZE.getOpt());
        args.add("1M,2M");
        args.add("-" + ConfigOption.REPLICATION_AM.getOpt());
        args.add("1,1");
        if (sleep) {
            args.add("-" + ConfigOption.SLEEP_TIME.getOpt());
            args.add("10,10");
        }
        args.add("-" + ConfigOption.RESULT_FILE.getOpt());
        args.add(TestSlive.getResultFile().toString());
        args.add("-" + ConfigOption.BASE_DIR.getOpt());
        args.add(TestSlive.getFlowLocation().toString());
        args.add("-" + ConfigOption.DURATION.getOpt());
        args.add("10");
        args.add("-" + ConfigOption.DIR_SIZE.getOpt());
        args.add("10");
        args.add("-" + ConfigOption.FILES.getOpt());
        args.add("10");
        args.add("-" + ConfigOption.TRUNCATE_SIZE.getOpt());
        args.add("0,1M");
        return args.toArray(new String[args.size()]);
    }

    @Test
    public void testFinder() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        PathFinder fr = new PathFinder(extractor, rnd);
        int maxIterations = 10000;
        HashSet<Path> files = new HashSet<Path>();
        for (int i = 0; i < maxIterations; ++i) {
            files.add(fr.getFile());
        }
        org.junit.jupiter.api.Assertions.assertTrue((files.size() == 10 ? 1 : 0) != 0);
        HashSet<Path> dirs = new HashSet<Path>();
        for (int i = 0; i < maxIterations; ++i) {
            dirs.add(fr.getDirectory());
        }
        org.junit.jupiter.api.Assertions.assertTrue((dirs.size() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testSelection() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        WeightSelector selector = new WeightSelector(extractor, rnd);
        int expected = Constants.OperationType.values().length;
        Operation op = null;
        HashSet<String> types = new HashSet<String>();
        FileSystem fs = FileSystem.get((Configuration)extractor.getConfig());
        while ((op = selector.select(1, 1)) != null) {
            op.run(fs);
            types.add(op.getType());
        }
        Assertions.assertThat((int)types.size()).isEqualTo(expected);
    }

    private ConfigExtractor getTestConfig(boolean sleep) throws Exception {
        ArgumentParser parser = new ArgumentParser(this.getTestArgs(sleep));
        ArgumentParser.ParsedOutput out = parser.parse();
        org.junit.jupiter.api.Assertions.assertTrue((!out.shouldOutputHelp() ? 1 : 0) != 0);
        ConfigMerger merge = new ConfigMerger();
        Configuration cfg = merge.getMerged(out, TestSlive.getBaseConfig());
        ConfigExtractor extractor = new ConfigExtractor(cfg);
        return extractor;
    }

    @BeforeEach
    public void ensureDeleted() throws Exception {
        this.rDelete(TestSlive.getTestFile());
        this.rDelete(TestSlive.getTestDir());
        this.rDelete(TestSlive.getTestRenameFile());
        this.rDelete(TestSlive.getResultFile());
        this.rDelete(TestSlive.getFlowLocation());
        this.rDelete(TestSlive.getImaginaryFile());
    }

    private void rDelete(File place) throws Exception {
        if (place.isFile()) {
            LOG.info("Deleting file " + place);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)place.delete());
        } else if (place.isDirectory()) {
            this.deleteDir(place);
        }
    }

    private void deleteDir(File dir) throws Exception {
        String[] fns;
        for (String afn : fns = dir.list()) {
            File fn = new File(dir, afn);
            this.rDelete(fn);
        }
        LOG.info("Deleting directory " + dir);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dir.delete());
    }

    @Test
    public void testArguments() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(true);
        org.junit.jupiter.api.Assertions.assertEquals((int)extractor.getOpCount(), (int)Constants.OperationType.values().length);
        Assertions.assertThat((int)extractor.getMapAmount()).isEqualTo(2);
        Assertions.assertThat((int)extractor.getReducerAmount()).isEqualTo(2);
        Range<Long> apRange = extractor.getAppendSize();
        Assertions.assertThat((int)apRange.getLower().intValue()).isEqualTo(0x100000);
        Assertions.assertThat((int)apRange.getUpper().intValue()).isEqualTo(0x200000);
        Range<Long> wRange = extractor.getWriteSize();
        Assertions.assertThat((int)wRange.getLower().intValue()).isEqualTo(0x100000);
        Assertions.assertThat((int)wRange.getUpper().intValue()).isEqualTo(0x200000);
        Range<Long> trRange = extractor.getTruncateSize();
        Assertions.assertThat((int)trRange.getLower().intValue()).isZero();
        Assertions.assertThat((int)trRange.getUpper().intValue()).isEqualTo(0x100000);
        Range<Long> bRange = extractor.getBlockSize();
        Assertions.assertThat((int)bRange.getLower().intValue()).isEqualTo(0x100000);
        Assertions.assertThat((int)bRange.getUpper().intValue()).isEqualTo(0x200000);
        String resfile = extractor.getResultFile();
        org.junit.jupiter.api.Assertions.assertEquals((Object)resfile, (Object)TestSlive.getResultFile().toString());
        int durationMs = extractor.getDurationMilliseconds();
        Assertions.assertThat((int)durationMs).isEqualTo(10000);
    }

    @Test
    public void testDataWriting() throws Exception {
        long byteAm = 100L;
        File fn = TestSlive.getTestFile();
        DataWriter writer = new DataWriter(rnd);
        FileOutputStream fs = new FileOutputStream(fn);
        DataWriter.GenerateOutput ostat = writer.writeSegment(byteAm, fs);
        LOG.info(ostat.toString());
        fs.close();
        org.junit.jupiter.api.Assertions.assertTrue((ostat.getBytesWritten() == byteAm ? 1 : 0) != 0);
        DataVerifier vf = new DataVerifier();
        FileInputStream fin = new FileInputStream(fn);
        DataVerifier.VerifyOutput vfout = vf.verifyFile(byteAm, new DataInputStream(fin));
        LOG.info(vfout.toString());
        fin.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)vfout.getBytesRead(), (long)byteAm);
        org.junit.jupiter.api.Assertions.assertTrue((vfout.getChunksDifferent() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRange() {
        Range<Long> r = new Range<Long>(10L, 20L);
        Assertions.assertThat((long)r.getLower()).isEqualTo(10L);
        Assertions.assertThat((long)r.getUpper()).isEqualTo(20L);
    }

    @Test
    public void testCreateOp() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getTestFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, op, true);
    }

    @Test
    public void testOpFailures() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getImaginaryFile().getCanonicalPath());
        ReadOp rop = new ReadOp(extractor, rnd){

            @Override
            protected Path getReadFile() {
                return fn;
            }
        };
        this.runOperationBad(extractor, rop);
        DeleteOp dop = new DeleteOp(extractor, rnd){

            @Override
            protected Path getDeleteFile() {
                return fn;
            }
        };
        this.runOperationBad(extractor, dop);
        RenameOp reop = new RenameOp(extractor, rnd){

            @Override
            protected RenameOp.SrcTarget getRenames() {
                return new RenameOp.SrcTarget(fn, fn);
            }
        };
        this.runOperationBad(extractor, reop);
        AppendOp aop = new AppendOp(extractor, rnd){

            @Override
            protected Path getAppendFile() {
                return fn;
            }
        };
        this.runOperationBad(extractor, aop);
    }

    private void runOperationBad(ConfigExtractor cfg, Operation op) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)cfg.getConfig());
        List<OperationOutput> data = op.run(fs);
        org.junit.jupiter.api.Assertions.assertTrue((!data.isEmpty() ? 1 : 0) != 0);
        boolean foundFail = false;
        for (OperationOutput d : data) {
            if (d.getMeasurementType().equals("failures")) {
                foundFail = true;
            }
            if (!d.getMeasurementType().equals("files_not_found")) continue;
            foundFail = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundFail);
    }

    private void runOperationOk(ConfigExtractor cfg, Operation op, boolean checkOk) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)cfg.getConfig());
        List<OperationOutput> data = op.run(fs);
        org.junit.jupiter.api.Assertions.assertTrue((!data.isEmpty() ? 1 : 0) != 0);
        if (checkOk) {
            boolean foundSuc = false;
            boolean foundOpCount = false;
            boolean foundTime = false;
            for (OperationOutput d : data) {
                org.junit.jupiter.api.Assertions.assertTrue((!d.getMeasurementType().equals("failures") ? 1 : 0) != 0);
                if (d.getMeasurementType().equals("successes")) {
                    foundSuc = true;
                }
                if (d.getMeasurementType().equals("op_count")) {
                    foundOpCount = true;
                }
                if (!d.getMeasurementType().equals("milliseconds_taken")) continue;
                foundTime = true;
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundSuc);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundOpCount);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)foundTime);
        }
    }

    @Test
    public void testDelete() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getTestFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, op, true);
        DeleteOp dop = new DeleteOp(extractor, rnd){

            @Override
            protected Path getDeleteFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, dop, true);
    }

    @Test
    public void testRename() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path src = new Path(TestSlive.getTestFile().getCanonicalPath());
        final Path tgt = new Path(TestSlive.getTestRenameFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return src;
            }
        };
        this.runOperationOk(extractor, op, true);
        RenameOp rop = new RenameOp(extractor, rnd){

            @Override
            protected RenameOp.SrcTarget getRenames() {
                return new RenameOp.SrcTarget(src, tgt);
            }
        };
        this.runOperationOk(extractor, rop, true);
    }

    @Test
    public void testMRFlow() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        SliveTest s = new SliveTest(TestSlive.getBaseConfig());
        int ec = ToolRunner.run((Tool)s, (String[])this.getTestArgs(false));
        org.junit.jupiter.api.Assertions.assertTrue((ec == 0 ? 1 : 0) != 0);
        String resFile = extractor.getResultFile();
        File fn = new File(resFile);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fn.exists());
    }

    @Test
    public void testRead() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getTestFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, op, true);
        ReadOp rop = new ReadOp(extractor, rnd){

            @Override
            protected Path getReadFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, rop, true);
    }

    @Test
    public void testSleep() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(true);
        SleepOp op = new SleepOp(extractor, rnd);
        this.runOperationOk(extractor, op, true);
    }

    @Test
    public void testList() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path dir = new Path(TestSlive.getTestDir().getCanonicalPath());
        MkdirOp op = new MkdirOp(extractor, rnd){

            @Override
            protected Path getDirectory() {
                return dir;
            }
        };
        this.runOperationOk(extractor, op, true);
        ListOp lop = new ListOp(extractor, rnd){

            @Override
            protected Path getDirectory() {
                return dir;
            }
        };
        this.runOperationOk(extractor, lop, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadChunks() throws Exception {
        File fn = TestSlive.getTestFile();
        int byteAm = 10000;
        FileOutputStream fout = new FileOutputStream(fn);
        byte[] bytes = new byte[byteAm];
        rnd.nextBytes(bytes);
        fout.write(bytes);
        fout.close();
        DataVerifier vf = new DataVerifier();
        DataVerifier.VerifyOutput vout = new DataVerifier.VerifyOutput(0L, 0L, 0L, 0L);
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(fn));
            vout = vf.verifyFile(byteAm, (DataInputStream)in);
        }
        org.junit.jupiter.api.Assertions.assertTrue((vout.getChunksSame() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMkdir() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path dir = new Path(TestSlive.getTestDir().getCanonicalPath());
        MkdirOp op = new MkdirOp(extractor, rnd){

            @Override
            protected Path getDirectory() {
                return dir;
            }
        };
        this.runOperationOk(extractor, op, true);
    }

    @Test
    public void testSelector() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        RouletteSelector selector = new RouletteSelector(rnd);
        LinkedList<OperationWeight> sList = new LinkedList<OperationWeight>();
        Operation op = selector.select(sList);
        org.junit.jupiter.api.Assertions.assertTrue((op == null ? 1 : 0) != 0);
        CreateOp cop = new CreateOp(extractor, rnd);
        sList.add(new OperationWeight(cop, 1.0));
        AppendOp aop = new AppendOp(extractor, rnd);
        sList.add(new OperationWeight(aop, 0.01));
        op = selector.select(sList);
        org.junit.jupiter.api.Assertions.assertTrue((op == cop ? 1 : 0) != 0);
    }

    @Test
    public void testAppendOp() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getTestFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, op, true);
        AppendOp aop = new AppendOp(extractor, rnd){

            @Override
            protected Path getAppendFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, aop, false);
    }

    @Test
    public void testTruncateOp() throws Exception {
        ConfigExtractor extractor = this.getTestConfig(false);
        final Path fn = new Path(TestSlive.getTestFile().getCanonicalPath());
        CreateOp op = new CreateOp(extractor, rnd){

            @Override
            protected Path getCreateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, op, true);
        TruncateOp top = new TruncateOp(extractor, rnd){

            @Override
            protected Path getTruncateFile() {
                return fn;
            }
        };
        this.runOperationOk(extractor, top, false);
    }
}

