/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJobOutputCommitter
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp") + "/test-job-output-committer").toString();
    private static final String CUSTOM_CLEANUP_FILE_NAME = "_custom_cleanup";
    private static final String ABORT_KILLED_FILE_NAME = "_custom_abort_killed";
    private static final String ABORT_FAILED_FILE_NAME = "_custom_abort_failed";
    private static Path inDir = new Path(TEST_ROOT_DIR, "test-input");
    private static int outDirs = 0;
    private FileSystem fs;
    private Configuration conf = null;

    public TestJobOutputCommitter() throws IOException {
        super(2, 4, 1, 1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.createJobConf();
        this.fs = this.getFileSystem();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fs.delete(new Path(TEST_ROOT_DIR), true);
        super.tearDown();
    }

    private Path getNewOutputDir() {
        return new Path(TEST_ROOT_DIR, "output-" + outDirs++);
    }

    private void testSuccessfulJob(String filename, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createJob(this.conf, inDir, outDir, 1, 0);
        job.setOutputFormatClass(output);
        Assert.assertTrue((String)"Job failed!", (boolean)job.waitForCompletion(true));
        Path testFile = new Path(outDir, filename);
        Assert.assertTrue((String)("Done file missing for job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            Assert.assertFalse((String)("File " + file + " should not be present for successful job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    private void testFailedJob(String fileName, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createFailJob(this.conf, outDir, inDir);
        job.setOutputFormatClass(output);
        Assert.assertFalse((String)"Job did not fail!", (boolean)job.waitForCompletion(true));
        if (fileName != null) {
            Path testFile = new Path(outDir, fileName);
            Assert.assertTrue((String)("File " + testFile + " missing for failed job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        }
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            Assert.assertFalse((String)("File " + file + " should not be present for failed job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    private void testKilledJob(String fileName, Class<? extends OutputFormat> output, String[] exclude) throws Exception {
        Path outDir = this.getNewOutputDir();
        Job job = MapReduceTestUtil.createKillJob(this.conf, outDir, inDir);
        job.setOutputFormatClass(output);
        job.submit();
        while (job.setupProgress() != 1.0f) {
            UtilsForTests.waitFor(100L);
        }
        job.killJob();
        Assert.assertFalse((String)"Job did not get kill", (boolean)job.waitForCompletion(true));
        if (fileName != null) {
            Path testFile = new Path(outDir, fileName);
            Assert.assertTrue((String)("File " + testFile + " missing for job " + job.getJobID()), (boolean)this.fs.exists(testFile));
        }
        for (String ex : exclude) {
            Path file = new Path(outDir, ex);
            Assert.assertFalse((String)("File " + file + " should not be present for killed job " + job.getJobID()), (boolean)this.fs.exists(file));
        }
    }

    @Test
    public void testDefaultCleanupAndAbort() throws Exception {
        this.testSuccessfulJob("_SUCCESS", TextOutputFormat.class, new String[0]);
        this.testFailedJob(null, TextOutputFormat.class, new String[]{"_SUCCESS"});
        this.testKilledJob(null, TextOutputFormat.class, new String[]{"_SUCCESS"});
    }

    @Test
    public void testCustomAbort() throws Exception {
        this.testSuccessfulJob("_SUCCESS", MyOutputFormatWithCustomAbort.class, new String[]{ABORT_FAILED_FILE_NAME, ABORT_KILLED_FILE_NAME});
        this.testFailedJob(ABORT_FAILED_FILE_NAME, MyOutputFormatWithCustomAbort.class, new String[]{"_SUCCESS", ABORT_KILLED_FILE_NAME});
        this.testKilledJob(ABORT_KILLED_FILE_NAME, MyOutputFormatWithCustomAbort.class, new String[]{"_SUCCESS", ABORT_FAILED_FILE_NAME});
    }

    @Test
    public void testCustomCleanup() throws Exception {
        this.testSuccessfulJob(CUSTOM_CLEANUP_FILE_NAME, MyOutputFormatWithCustomCleanup.class, new String[0]);
        this.testFailedJob(CUSTOM_CLEANUP_FILE_NAME, MyOutputFormatWithCustomCleanup.class, new String[]{"_SUCCESS"});
        this.testKilledJob(CUSTOM_CLEANUP_FILE_NAME, MyOutputFormatWithCustomCleanup.class, new String[]{"_SUCCESS"});
    }

    static class MyOutputFormatWithCustomAbort<K, V>
    extends TextOutputFormat<K, V> {
        private OutputCommitter committer = null;

        MyOutputFormatWithCustomAbort() {
        }

        public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
            if (this.committer == null) {
                Path output = MyOutputFormatWithCustomAbort.getOutputPath((JobContext)context);
                this.committer = new CommitterWithCustomAbort(output, context);
            }
            return this.committer;
        }
    }

    static class MyOutputFormatWithCustomCleanup<K, V>
    extends TextOutputFormat<K, V> {
        private OutputCommitter committer = null;

        MyOutputFormatWithCustomCleanup() {
        }

        public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
            if (this.committer == null) {
                Path output = MyOutputFormatWithCustomCleanup.getOutputPath((JobContext)context);
                this.committer = new CommitterWithCustomDeprecatedCleanup(output, context);
            }
            return this.committer;
        }
    }

    static class CommitterWithCustomAbort
    extends FileOutputCommitter {
        public CommitterWithCustomAbort(Path outputPath, TaskAttemptContext context) throws IOException {
            super(outputPath, context);
        }

        public void abortJob(JobContext context, JobStatus.State state) throws IOException {
            Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
            FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
            String fileName = state.equals((Object)JobStatus.State.FAILED) ? TestJobOutputCommitter.ABORT_FAILED_FILE_NAME : TestJobOutputCommitter.ABORT_KILLED_FILE_NAME;
            fs.create(new Path(outputPath, fileName)).close();
        }
    }

    static class CommitterWithCustomDeprecatedCleanup
    extends FileOutputCommitter {
        public CommitterWithCustomDeprecatedCleanup(Path outputPath, TaskAttemptContext context) throws IOException {
            super(outputPath, context);
        }

        public void cleanupJob(JobContext context) throws IOException {
            System.err.println("---- HERE ----");
            Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
            FileSystem fs = outputPath.getFileSystem(context.getConfiguration());
            fs.create(new Path(outputPath, TestJobOutputCommitter.CUSTOM_CLEANUP_FILE_NAME)).close();
        }
    }
}

