/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestChild
extends HadoopTestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path inDir = new Path(TEST_ROOT_DIR, "./wc/input");
    private final Path outDir = new Path(TEST_ROOT_DIR, "./wc/output");
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";

    public TestChild() throws IOException {
        super(2, 4, 2, 2);
    }

    private Job submitAndValidateJob(JobConf conf, int numMaps, int numReds, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        conf.setBoolean(OLD_CONFIGS, oldConfigs);
        if (oldConfigs) {
            conf.set("mapred.child.java.opts", "-Xmx200m");
        } else {
            conf.set("mapreduce.map.java.opts", "-Xmx200m");
            conf.set("mapreduce.reduce.java.opts", REDUCE_OPTS_VAL);
        }
        conf.set("mapreduce.map.log.level", Level.OFF.toString());
        conf.set("mapreduce.reduce.log.level", Level.OFF.toString());
        Job job = MapReduceTestUtil.createJob((Configuration)conf, this.inDir, this.outDir, numMaps, numReds);
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        Assert.assertFalse((String)"Job already has a job tracker connection, before it's submitted", (boolean)job.isConnected());
        job.submit();
        Assert.assertTrue((String)"Job doesn't have a job tracker connection, even though it's been submitted", (boolean)job.isConnected());
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)job.isSuccessful());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertTrue((String)"Job output directory doesn't exit!", (boolean)fs.exists(this.outDir));
        FileStatus[] list = fs.listStatus(this.outDir, (PathFilter)new OutputFilter());
        int numPartFiles = numReds == 0 ? numMaps : numReds;
        Assert.assertTrue((String)("Number of part-files is " + list.length + " and not " + numPartFiles), (list.length == numPartFiles ? 1 : 0) != 0);
        return job;
    }

    @Test
    public void testChild() throws Exception {
        try {
            this.submitAndValidateJob(this.createJobConf(), 1, 1, true);
            this.submitAndValidateJob(this.createJobConf(), 1, 1, false);
        }
        finally {
            this.tearDown();
        }
    }

    static class MyMapper
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        MyMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (Object)javaOpts, (Object)"-Xmx200m");
            } else {
                String mapJavaOpts = conf.get("mapreduce.map.java.opts");
                Assert.assertNotNull((String)"mapreduce.map.java.opts is null!", (Object)mapJavaOpts);
                Assert.assertEquals((String)("mapreduce.map.java.opts has value of: " + mapJavaOpts), (Object)mapJavaOpts, (Object)"-Xmx200m");
            }
            Level logLevel = Level.toLevel((String)conf.get("mapreduce.map.log.level", Level.INFO.toString()));
            Assert.assertEquals((String)("mapreduce.map.log.levelhas value of " + logLevel), (Object)logLevel, (Object)Level.OFF);
        }
    }

    static class MyReducer
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        MyReducer() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            boolean oldConfigs = conf.getBoolean(TestChild.OLD_CONFIGS, false);
            if (oldConfigs) {
                String javaOpts = conf.get("mapred.child.java.opts");
                Assert.assertNotNull((String)"mapred.child.java.opts is null!", (Object)javaOpts);
                Assert.assertEquals((String)("mapred.child.java.opts has value of: " + javaOpts), (Object)javaOpts, (Object)"-Xmx200m");
            } else {
                String reduceJavaOpts = conf.get("mapreduce.reduce.java.opts");
                Assert.assertNotNull((String)"mapreduce.reduce.java.opts is null!", (Object)reduceJavaOpts);
                Assert.assertEquals((String)("mapreduce.reduce.java.opts has value of: " + reduceJavaOpts), (Object)reduceJavaOpts, (Object)TestChild.REDUCE_OPTS_VAL);
            }
            Level logLevel = Level.toLevel((String)conf.get("mapreduce.reduce.log.level", Level.INFO.toString()));
            Assert.assertEquals((String)("mapreduce.reduce.log.levelhas value of " + logLevel), (Object)logLevel, (Object)Level.OFF);
        }
    }

    private static class OutputFilter
    implements PathFilter {
        private OutputFilter() {
        }

        public boolean accept(Path path) {
            return !path.getName().startsWith("_");
        }
    }
}

