/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.checkpoint.TaskCheckpointID;
import org.apache.hadoop.util.Progressable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskCommit
extends HadoopTestCase {
    Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), "test");

    public TestTaskCommit() throws IOException {
        super(1, 4, 1, 1);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        FileUtil.fullyDelete((File)new File(this.rootDir.toString()));
    }

    @Test
    public void testCommitFail() throws IOException {
        Path inDir = new Path(this.rootDir, "./input");
        Path outDir = new Path(this.rootDir, "./output");
        JobConf jobConf = this.createJobConf();
        jobConf.setMaxMapAttempts(1);
        jobConf.setOutputCommitter(CommitterWithCommitFail.class);
        RunningJob rJob = UtilsForTests.runJob(jobConf, inDir, outDir, 1, 0);
        rJob.waitForCompletion();
        Assert.assertEquals((long)JobStatus.FAILED, (long)rJob.getJobState());
    }

    @Test
    public void testTaskCleanupDoesNotCommit() throws Exception {
        JobConf job = new JobConf();
        job.setOutputCommitter(CommitterWithoutCleanup.class);
        Path outDir = new Path(this.rootDir, "output");
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        String dummyAttemptID = "attempt_200707121733_0001_m_000000_0";
        TaskAttemptID attemptID = TaskAttemptID.forName((String)dummyAttemptID);
        CommitterWithoutCleanup committer = new CommitterWithoutCleanup();
        JobContextImpl jContext = new JobContextImpl(job, (org.apache.hadoop.mapreduce.JobID)attemptID.getJobID());
        committer.setupJob((JobContext)jContext);
        dummyAttemptID = "attempt_200707121733_0001_m_000001_0";
        attemptID = TaskAttemptID.forName((String)dummyAttemptID);
        MapTask task = new MapTask(null, attemptID, 0, null, 1);
        task.setConf((Configuration)job);
        task.localizeConfiguration(job);
        task.initialize(job, attemptID.getJobID(), Reporter.NULL, false);
        String file = "test.txt";
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, file, (Progressable)Reporter.NULL);
        theRecordWriter.write((Object)new Text("key"), (Object)new Text("value"));
        theRecordWriter.close(Reporter.NULL);
        task.setTaskCleanupTask();
        MyUmbilical umbilical = new MyUmbilical();
        task.run(job, (TaskUmbilicalProtocol)umbilical);
        Assert.assertTrue((String)"Task did not succeed", (boolean)umbilical.taskDone);
    }

    @Test
    public void testCommitRequiredForMapTask() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        Assert.assertTrue((String)"MapTask should need commit", (boolean)testTask.isCommitRequired());
    }

    @Test
    public void testCommitRequiredForReduceTask() throws Exception {
        Task testTask = this.createDummyTask(TaskType.REDUCE);
        Assert.assertTrue((String)"ReduceTask should need commit", (boolean)testTask.isCommitRequired());
    }

    @Test
    public void testCommitNotRequiredForJobSetup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        testTask.setJobSetupTask();
        Assert.assertFalse((String)"Job setup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    @Test
    public void testCommitNotRequiredForJobCleanup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        testTask.setJobCleanupTask();
        Assert.assertFalse((String)"Job cleanup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    @Test
    public void testCommitNotRequiredForTaskCleanup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.REDUCE);
        testTask.setTaskCleanupTask();
        Assert.assertFalse((String)"Task cleanup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    private Task createDummyTask(TaskType type) throws IOException, ClassNotFoundException, InterruptedException {
        JobConf conf = new JobConf();
        conf.setOutputCommitter(CommitterThatAlwaysRequiresCommit.class);
        Path outDir = new Path(this.rootDir, "output");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobID jobId = JobID.forName((String)"job_201002121132_0001");
        Object testTask = type == TaskType.MAP ? new MapTask() : new ReduceTask();
        testTask.setConf((Configuration)conf);
        testTask.initialize(conf, jobId, Reporter.NULL, false);
        return testTask;
    }

    public static void main(String[] argv) throws Exception {
        TestTaskCommit td = new TestTaskCommit();
        td.testCommitFail();
    }

    static class CommitterWithCommitFail
    extends FileOutputCommitter {
        CommitterWithCommitFail() {
        }

        public void commitTask(TaskAttemptContext context) throws IOException {
            FileSystem fs;
            Path taskOutputPath = this.getTaskAttemptPath(context);
            TaskAttemptID attemptId = context.getTaskAttemptID();
            JobConf job = context.getJobConf();
            if (taskOutputPath != null && (fs = taskOutputPath.getFileSystem((Configuration)job)).exists(taskOutputPath)) {
                throw new IOException();
            }
        }
    }

    static class CommitterWithoutCleanup
    extends FileOutputCommitter {
        CommitterWithoutCleanup() {
        }

        public void abortTask(TaskAttemptContext context) throws IOException {
        }
    }

    private class MyUmbilical
    implements TaskUmbilicalProtocol {
        boolean taskDone = false;

        private MyUmbilical() {
        }

        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return false;
        }

        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            Assert.fail((String)"Task should not go to commit-pending");
        }

        public void done(TaskAttemptID taskid) throws IOException {
            this.taskDone = true;
        }

        public void fatalError(TaskAttemptID taskId, String message, boolean fastFail) throws IOException {
        }

        public void fsError(TaskAttemptID taskId, String message) throws IOException {
        }

        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromIndex, int maxLocs, TaskAttemptID id) throws IOException {
            return null;
        }

        public JvmTask getTask(JvmContext context) throws IOException {
            return null;
        }

        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
        }

        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
        }

        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
        }

        public AMFeedback statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            AMFeedback a = new AMFeedback();
            a.setTaskFound(true);
            return a;
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return null;
        }

        public void preempted(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            Assert.fail((String)"Task should not go to commit-pending");
        }

        public TaskCheckpointID getCheckpointID(TaskID taskId) {
            return null;
        }

        public void setCheckpointID(TaskID downgrade, TaskCheckpointID cid) {
        }
    }

    static class CommitterThatAlwaysRequiresCommit
    extends FileOutputCommitter {
        CommitterThatAlwaysRequiresCommit() {
        }

        public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
            return true;
        }
    }
}

