/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.UtilsForTests;
import org.junit.Test;

public class TestCollect {
    static final Path OUTPUT_DIR = new Path("build/test/test.collect.output");
    static final int NUM_FEEDERS = 10;
    static final int NUM_COLLECTS_PER_THREAD = 1000;

    public void configure(JobConf conf) throws IOException {
        conf.setJobName("TestCollect");
        conf.setJarByClass(TestCollect.class);
        conf.setInputFormat(UtilsForTests.RandomInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(IntWritable.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)OUTPUT_DIR);
        conf.set("mapreduce.framework.name", "local");
        conf.setMapperClass(Map.class);
        conf.setReducerClass(Reduce.class);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
    }

    @Test
    public void testCollect() throws IOException {
        JobConf conf = new JobConf();
        this.configure(conf);
        try {
            JobClient.runJob((JobConf)conf);
            if (Reduce.numSeen != 10000) {
                throw new IOException("Collect test failed!! Total does not match.");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(OUTPUT_DIR, true);
        }
    }

    static class Map
    implements Mapper<Text, Text, IntWritable, IntWritable> {
        Map() {
        }

        public void configure(JobConf job) {
        }

        public void map(Text key, Text val, final OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int i;
            class CollectFeeder
            extends Thread {
                int id;

                public CollectFeeder(int id) {
                    this.id = id;
                }

                @Override
                public void run() {
                    for (int j = 1; j <= 1000; ++j) {
                        try {
                            out.collect((Object)new IntWritable(this.id * 1000 + j), (Object)new IntWritable(0));
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            CollectFeeder[] feeders = new CollectFeeder[10];
            for (i = 0; i < 10; ++i) {
                feeders[i] = new CollectFeeder(i);
                feeders[i].start();
            }
            for (i = 0; i < 10; ++i) {
                try {
                    feeders[i].join();
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie.toString());
                }
            }
        }

        public void close() {
        }
    }

    static class Reduce
    implements Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        static int numSeen;
        static int actualSum;

        Reduce() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> val, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int expectedSum;
            if ((expectedSum = ++numSeen * (numSeen + 1) / 2) != (actualSum += key.get())) {
                throw new IOException("Collect test failed!! Ordering mismatch.");
            }
        }

        public void close() {
        }
    }
}

