/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSplit {
    static final int META_SPLIT_VERSION = 1;
    static final byte[] META_SPLIT_FILE_HEADER = "META-SPL".getBytes(StandardCharsets.UTF_8);
    public static final TaskSplitMetaInfo EMPTY_TASK_SPLIT = new TaskSplitMetaInfo();

    public static class TaskSplitIndex {
        private String splitLocation;
        private long startOffset;

        public TaskSplitIndex() {
            this("", 0L);
        }

        public TaskSplitIndex(String splitLocation, long startOffset) {
            this.splitLocation = splitLocation;
            this.startOffset = startOffset;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public String getSplitLocation() {
            return this.splitLocation;
        }

        public void readFields(DataInput in) throws IOException {
            this.splitLocation = Text.readString((DataInput)in);
            this.startOffset = WritableUtils.readVLong((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.splitLocation);
            WritableUtils.writeVLong((DataOutput)out, (long)this.startOffset);
        }
    }

    public static class TaskSplitMetaInfo {
        private TaskSplitIndex splitIndex;
        private long inputDataLength;
        private String[] locations;

        public TaskSplitMetaInfo() {
            this.splitIndex = new TaskSplitIndex();
            this.locations = new String[0];
        }

        public TaskSplitMetaInfo(TaskSplitIndex splitIndex, String[] locations, long inputDataLength) {
            this.splitIndex = splitIndex;
            this.locations = locations;
            this.inputDataLength = inputDataLength;
        }

        public TaskSplitMetaInfo(InputSplit split, long startOffset) throws InterruptedException, IOException {
            this(new TaskSplitIndex("", startOffset), split.getLocations(), split.getLength());
        }

        public TaskSplitMetaInfo(String[] locations, long startOffset, long inputDataLength) {
            this(new TaskSplitIndex("", startOffset), locations, inputDataLength);
        }

        public TaskSplitIndex getSplitIndex() {
            return this.splitIndex;
        }

        public String getSplitLocation() {
            return this.splitIndex.getSplitLocation();
        }

        public long getInputDataLength() {
            return this.inputDataLength;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public long getStartOffset() {
            return this.splitIndex.getStartOffset();
        }
    }

    public static class SplitMetaInfo
    implements Writable {
        private long startOffset;
        private long inputDataLength;
        private String[] locations;

        public SplitMetaInfo() {
        }

        public SplitMetaInfo(String[] locations, long startOffset, long inputDataLength) {
            this.locations = locations;
            this.startOffset = startOffset;
            this.inputDataLength = inputDataLength;
        }

        public SplitMetaInfo(InputSplit split, long startOffset) throws IOException {
            try {
                this.locations = split.getLocations();
                this.inputDataLength = split.getLength();
                this.startOffset = startOffset;
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        public String[] getLocations() {
            return this.locations;
        }

        public long getStartOffset() {
            return this.startOffset;
        }

        public long getInputDataLength() {
            return this.inputDataLength;
        }

        public void setInputDataLocations(String[] locations) {
            this.locations = locations;
        }

        public void setInputDataLength(long length) {
            this.inputDataLength = length;
        }

        public void readFields(DataInput in) throws IOException {
            int len = WritableUtils.readVInt((DataInput)in);
            this.locations = new String[len];
            for (int i = 0; i < this.locations.length; ++i) {
                this.locations[i] = Text.readString((DataInput)in);
            }
            this.startOffset = WritableUtils.readVLong((DataInput)in);
            this.inputDataLength = WritableUtils.readVLong((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVInt((DataOutput)out, (int)this.locations.length);
            for (int i = 0; i < this.locations.length; ++i) {
                Text.writeString((DataOutput)out, (String)this.locations[i]);
            }
            WritableUtils.writeVLong((DataOutput)out, (long)this.startOffset);
            WritableUtils.writeVLong((DataOutput)out, (long)this.inputDataLength);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("data-size : " + this.inputDataLength + "\n");
            buf.append("start-offset : " + this.startOffset + "\n");
            buf.append("locations : \n");
            for (String loc : this.locations) {
                buf.append("  " + loc + "\n");
            }
            return buf.toString();
        }
    }
}

