/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSetters;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.LoadedManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbstractJobOrTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CreateOutputDirectoriesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.LoadManifestsStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.RenameFilesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SaveSuccessFileStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.ValidateRenamedFilesStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitJobStage
extends AbstractJobOrTaskStage<Arguments, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitJobStage.class);

    public CommitJobStage(StageConfig stageConfig) {
        super(false, stageConfig, "committer_commit_job", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Result executeStage(Arguments arguments) throws IOException {
        LOG.info("{}: Committing job \"{}\". resilient commit supported = {}", new Object[]{this.getName(), this.getJobId(), this.storeSupportsResilientCommit()});
        LoadedManifestData loadedManifestData = null;
        try {
            boolean createMarker = arguments.isCreateMarker();
            IOStatisticsSnapshot heapInfo = new IOStatisticsSnapshot();
            ManifestCommitterSupport.addHeapInformation((IOStatisticsSetters)heapInfo, "setup");
            StageConfig stageConfig = this.getStageConfig();
            LoadManifestsStage.Result result = (LoadManifestsStage.Result)new LoadManifestsStage(stageConfig).apply(new LoadManifestsStage.Arguments(File.createTempFile("manifest", ".list"), stageConfig.getWriterQueueCapacity()));
            LoadManifestsStage.SummaryInfo loadedManifestSummary = result.getSummary();
            loadedManifestData = result.getLoadedManifestData();
            LOG.debug("{}: Job Summary {}", (Object)this.getName(), (Object)loadedManifestSummary);
            LOG.info("{}: Committing job with file count: {}; total size {} bytes", new Object[]{this.getName(), loadedManifestSummary.getFileCount(), String.format("%,d", loadedManifestSummary.getTotalFileSize())});
            ManifestCommitterSupport.addHeapInformation((IOStatisticsSetters)heapInfo, "job_stage_load_manifests");
            IOStatisticsStore iostats = this.getIOStatistics();
            iostats.aggregate((IOStatistics)loadedManifestSummary.getIOStatistics());
            CreateOutputDirectoriesStage.Result dirStageResults = (CreateOutputDirectoriesStage.Result)new CreateOutputDirectoriesStage(stageConfig).apply(loadedManifestData.getDirectories());
            ManifestCommitterSupport.addHeapInformation((IOStatisticsSetters)heapInfo, "job_stage_create_target_dirs");
            ManifestSuccessData successData = (ManifestSuccessData)new RenameFilesStage(stageConfig).apply(Triple.of((Object)loadedManifestData, dirStageResults.getCreatedDirectories(), (Object)stageConfig.getSuccessMarkerFileLimit()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: _SUCCESS file summary {}", (Object)this.getName(), (Object)successData.toJson());
            }
            ManifestCommitterSupport.addHeapInformation((IOStatisticsSetters)heapInfo, "job_stage_rename_files");
            iostats.setCounter("committer_files_committed", loadedManifestSummary.getFileCount());
            iostats.setCounter("committer_bytes_committed", loadedManifestSummary.getTotalFileSize());
            successData.snapshotIOStatistics((IOStatistics)iostats);
            successData.getIOStatistics().aggregate((IOStatistics)heapInfo);
            String manifestRenameDir = arguments.getManifestRenameDir();
            if (StringUtils.isNotBlank((CharSequence)manifestRenameDir)) {
                Path manifestRenamePath = new Path(new Path(manifestRenameDir), this.getJobId());
                LOG.info("{}: Renaming manifests to {}", (Object)this.getName(), (Object)manifestRenamePath);
                try {
                    this.renameDir(this.getTaskManifestDir(), manifestRenamePath);
                    successData.getDiagnostics().put("manifests", manifestRenamePath.toUri().toString());
                }
                catch (IOException | IllegalArgumentException e) {
                    LOG.warn("{}: Failed to rename manifests to {}", new Object[]{this.getName(), manifestRenamePath, e});
                }
            }
            Path successPath = null;
            if (createMarker) {
                successPath = (Path)new SaveSuccessFileStage(stageConfig).apply(successData);
                LOG.debug("{}: Saving _SUCCESS file to {}", (Object)this.getName(), (Object)successPath);
            }
            CleanupJobStage.Arguments cleanupArguments = arguments.getCleanupArguments();
            cleanupArguments.setDirectoryCount(iostats.counters().getOrDefault("committer_task_directory_count", 0L));
            new CleanupJobStage(stageConfig).apply(cleanupArguments);
            if (arguments.isValidateOutput()) {
                LOG.info("{}: Validating output.", (Object)this.getName());
                new ValidateRenamedFilesStage(stageConfig).apply(loadedManifestData.getEntrySequenceData());
            }
            stageConfig.enterStage(this.getStageName(arguments));
            Result result2 = new Result(successPath, successData);
            return result2;
        }
        finally {
            if (loadedManifestData != null) {
                loadedManifestData.deleteEntrySequenceFile();
            }
        }
    }

    public static final class Arguments {
        private final boolean createMarker;
        private final boolean validateOutput;
        private final String manifestRenameDir;
        private final CleanupJobStage.Arguments cleanupArguments;

        public Arguments(boolean createMarker, boolean validateOutput, @Nullable String manifestRenameDir, CleanupJobStage.Arguments cleanupArguments) {
            this.createMarker = createMarker;
            this.validateOutput = validateOutput;
            this.manifestRenameDir = manifestRenameDir;
            this.cleanupArguments = Objects.requireNonNull(cleanupArguments);
        }

        public boolean isCreateMarker() {
            return this.createMarker;
        }

        public boolean isValidateOutput() {
            return this.validateOutput;
        }

        public String getManifestRenameDir() {
            return this.manifestRenameDir;
        }

        public CleanupJobStage.Arguments getCleanupArguments() {
            return this.cleanupArguments;
        }
    }

    public static final class Result {
        private final ManifestSuccessData jobSuccessData;
        private final Path successPath;

        public Result(Path successPath, ManifestSuccessData jobSuccessData) {
            this.successPath = successPath;
            this.jobSuccessData = jobSuccessData;
        }

        public ManifestSuccessData getJobSuccessData() {
            return this.jobSuccessData;
        }

        public Path getSuccessPath() {
            return this.successPath;
        }
    }
}

