/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.fieldsel;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FieldSelectionHelper {
    public static Text emptyText = new Text("");
    public static final String DATA_FIELD_SEPARATOR = "mapreduce.fieldsel.data.field.separator";
    @Deprecated
    public static final String DATA_FIELD_SEPERATOR = "mapreduce.fieldsel.data.field.separator";
    public static final String MAP_OUTPUT_KEY_VALUE_SPEC = "mapreduce.fieldsel.map.output.key.value.fields.spec";
    public static final String REDUCE_OUTPUT_KEY_VALUE_SPEC = "mapreduce.fieldsel.reduce.output.key.value.fields.spec";
    private Text key = null;
    private Text value = null;

    private static int extractFields(String[] fieldListSpec, List<Integer> fieldList) {
        int allFieldsFrom = -1;
        int i = 0;
        int j = 0;
        int pos = -1;
        String fieldSpec = null;
        for (i = 0; i < fieldListSpec.length; ++i) {
            fieldSpec = fieldListSpec[i];
            if (fieldSpec.length() == 0) continue;
            pos = fieldSpec.indexOf(45);
            if (pos < 0) {
                Integer fn = Integer.valueOf(fieldSpec);
                fieldList.add(fn);
                continue;
            }
            String start = fieldSpec.substring(0, pos);
            String end = fieldSpec.substring(pos + 1);
            if (start.length() == 0) {
                start = "0";
            }
            if (end.length() == 0) {
                allFieldsFrom = Integer.parseInt(start);
                continue;
            }
            int startPos = Integer.parseInt(start);
            int endPos = Integer.parseInt(end);
            for (j = startPos; j <= endPos; ++j) {
                fieldList.add(j);
            }
        }
        return allFieldsFrom;
    }

    private static String selectFields(String[] fields, List<Integer> fieldList, int allFieldsFrom, String separator) {
        String retv = null;
        int i = 0;
        StringBuilder sb = null;
        if (fieldList != null && fieldList.size() > 0) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            for (Integer index : fieldList) {
                if (index < fields.length) {
                    sb.append(fields[index]);
                }
                sb.append(separator);
            }
        }
        if (allFieldsFrom >= 0) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            for (i = allFieldsFrom; i < fields.length; ++i) {
                sb.append(fields[i]).append(separator);
            }
        }
        if (sb != null && (retv = sb.toString()).length() > 0) {
            retv = retv.substring(0, retv.length() - 1);
        }
        return retv;
    }

    public static int parseOutputKeyValueSpec(String keyValueSpec, List<Integer> keyFieldList, List<Integer> valueFieldList) {
        String[] keyValSpecs = keyValueSpec.split(":", -1);
        String[] keySpec = keyValSpecs[0].split(",");
        String[] valSpec = new String[]{};
        if (keyValSpecs.length > 1) {
            valSpec = keyValSpecs[1].split(",");
        }
        FieldSelectionHelper.extractFields(keySpec, keyFieldList);
        return FieldSelectionHelper.extractFields(valSpec, valueFieldList);
    }

    public static String specToString(String fieldSeparator, String keyValueSpec, int allValueFieldsFrom, List<Integer> keyFieldList, List<Integer> valueFieldList) {
        StringBuilder sb = new StringBuilder();
        sb.append("fieldSeparator: ").append(fieldSeparator).append("\n");
        sb.append("keyValueSpec: ").append(keyValueSpec).append("\n");
        sb.append("allValueFieldsFrom: ").append(allValueFieldsFrom);
        sb.append("\n");
        sb.append("keyFieldList.length: ").append(keyFieldList.size());
        sb.append("\n");
        for (Integer field : keyFieldList) {
            sb.append("\t").append(field).append("\n");
        }
        sb.append("valueFieldList.length: ").append(valueFieldList.size());
        sb.append("\n");
        for (Integer field : valueFieldList) {
            sb.append("\t").append(field).append("\n");
        }
        return sb.toString();
    }

    public FieldSelectionHelper() {
    }

    public FieldSelectionHelper(Text key, Text val) {
        this.key = key;
        this.value = val;
    }

    public Text getKey() {
        return this.key;
    }

    public Text getValue() {
        return this.value;
    }

    public void extractOutputKeyValue(String key, String val, String fieldSep, List<Integer> keyFieldList, List<Integer> valFieldList, int allValueFieldsFrom, boolean ignoreKey, boolean isMap) {
        if (!ignoreKey) {
            val = key + (String)val;
        }
        String[] fields = ((String)val).split(fieldSep);
        String newKey = FieldSelectionHelper.selectFields(fields, keyFieldList, -1, fieldSep);
        String newVal = FieldSelectionHelper.selectFields(fields, valFieldList, allValueFieldsFrom, fieldSep);
        if (isMap && newKey == null) {
            newKey = newVal;
            newVal = null;
        }
        if (newKey != null) {
            this.key = new Text(newKey);
        }
        if (newVal != null) {
            this.value = new Text(newVal);
        }
    }
}

