/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventWriter {
    static final String VERSION = "Avro-Json";
    static final String VERSION_BINARY = "Avro-Binary";
    private FSDataOutputStream out;
    private DatumWriter<Event> writer = new SpecificDatumWriter(Event.class);
    private Encoder encoder;
    private static final Logger LOG = LoggerFactory.getLogger(EventWriter.class);
    private final WriteMode writeMode;
    private final boolean jsonOutput;
    private static final Schema GROUPS = Schema.createArray((Schema)JhCounterGroup.SCHEMA$);
    private static final Schema COUNTERS = Schema.createArray((Schema)JhCounter.SCHEMA$);

    @VisibleForTesting
    public EventWriter(FSDataOutputStream out, WriteMode mode) throws IOException {
        this.out = out;
        this.writeMode = mode;
        if (this.writeMode == WriteMode.JSON) {
            this.jsonOutput = true;
            out.writeBytes(VERSION);
        } else if (this.writeMode == WriteMode.BINARY) {
            this.jsonOutput = false;
            out.writeBytes(VERSION_BINARY);
        } else {
            throw new IOException("Unknown mode: " + mode);
        }
        out.writeBytes("\n");
        out.writeBytes(Event.SCHEMA$.toString());
        out.writeBytes("\n");
        this.encoder = !this.jsonOutput ? EncoderFactory.get().binaryEncoder((OutputStream)out, null) : EncoderFactory.get().jsonEncoder(Event.SCHEMA$, (OutputStream)out);
    }

    synchronized void write(HistoryEvent event) throws IOException {
        Event wrapper = new Event();
        wrapper.setType(event.getEventType());
        wrapper.setEvent(event.getDatum());
        this.writer.write((Object)wrapper, this.encoder);
        if (this.jsonOutput) {
            this.encoder.flush();
            this.out.writeBytes("\n");
        }
    }

    void flush() throws IOException {
        this.encoder.flush();
        this.out.flush();
        this.out.hflush();
    }

    @VisibleForTesting
    public void close() throws IOException {
        try {
            this.encoder.flush();
            this.out.close();
            this.out = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.out});
    }

    static JhCounters toAvro(Counters counters) {
        return EventWriter.toAvro(counters, "COUNTERS");
    }

    static JhCounters toAvro(Counters counters, String name) {
        JhCounters result = new JhCounters();
        result.setName((CharSequence)new Utf8(name));
        result.setGroups(new ArrayList<JhCounterGroup>(0));
        if (counters == null) {
            return result;
        }
        for (CounterGroup group : counters) {
            JhCounterGroup g = new JhCounterGroup();
            g.setName((CharSequence)new Utf8(group.getName()));
            g.setDisplayName((CharSequence)new Utf8(group.getDisplayName()));
            g.setCounts(new ArrayList<JhCounter>(group.size()));
            for (Counter counter : group) {
                JhCounter c = new JhCounter();
                c.setName((CharSequence)new Utf8(counter.getName()));
                c.setDisplayName((CharSequence)new Utf8(counter.getDisplayName()));
                c.setValue(counter.getValue());
                g.getCounts().add(c);
            }
            result.getGroups().add(g);
        }
        return result;
    }

    public static enum WriteMode {
        JSON,
        BINARY;

    }
}

