/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventReader
implements Closeable {
    private String version;
    private Schema schema;
    private DataInputStream in;
    private Decoder decoder;
    private DatumReader reader;

    public EventReader(FileSystem fs, Path name) throws IOException {
        this((DataInputStream)fs.open(name));
    }

    public EventReader(DataInputStream in) throws IOException {
        this.in = in;
        this.version = in.readLine();
        Schema myschema = new SpecificData(Event.class.getClassLoader()).getSchema(Event.class);
        Schema.Parser parser = new Schema.Parser();
        String eventschema = in.readLine();
        if (null != eventschema) {
            try {
                this.schema = parser.parse(eventschema);
                this.reader = new SpecificDatumReader(this.schema, myschema);
                if ("Avro-Json".equals(this.version)) {
                    this.decoder = DecoderFactory.get().jsonDecoder(this.schema, (InputStream)in);
                }
                if ("Avro-Binary".equals(this.version)) {
                    this.decoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
                }
                throw new IOException("Incompatible event log version: " + this.version);
            }
            catch (AvroRuntimeException e) {
                throw new IOException(e);
            }
        } else {
            throw new IOException("Event schema string not parsed since its null");
        }
    }

    public HistoryEvent getNextEvent() throws IOException {
        Event wrapper;
        try {
            wrapper = (Event)((Object)this.reader.read(null, this.decoder));
        }
        catch (EOFException e) {
            return null;
        }
        HistoryEvent result = switch (wrapper.getType()) {
            case EventType.JOB_SUBMITTED -> new JobSubmittedEvent();
            case EventType.JOB_INITED -> new JobInitedEvent();
            case EventType.JOB_FINISHED -> new JobFinishedEvent();
            case EventType.JOB_PRIORITY_CHANGED -> new JobPriorityChangeEvent();
            case EventType.JOB_QUEUE_CHANGED -> new JobQueueChangeEvent();
            case EventType.JOB_STATUS_CHANGED -> new JobStatusChangedEvent();
            case EventType.JOB_FAILED -> new JobUnsuccessfulCompletionEvent();
            case EventType.JOB_KILLED -> new JobUnsuccessfulCompletionEvent();
            case EventType.JOB_ERROR -> new JobUnsuccessfulCompletionEvent();
            case EventType.JOB_INFO_CHANGED -> new JobInfoChangeEvent();
            case EventType.TASK_STARTED -> new TaskStartedEvent();
            case EventType.TASK_FINISHED -> new TaskFinishedEvent();
            case EventType.TASK_FAILED -> new TaskFailedEvent();
            case EventType.TASK_UPDATED -> new TaskUpdatedEvent();
            case EventType.MAP_ATTEMPT_STARTED -> new TaskAttemptStartedEvent();
            case EventType.MAP_ATTEMPT_FINISHED -> new MapAttemptFinishedEvent();
            case EventType.MAP_ATTEMPT_FAILED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.MAP_ATTEMPT_KILLED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.REDUCE_ATTEMPT_STARTED -> new TaskAttemptStartedEvent();
            case EventType.REDUCE_ATTEMPT_FINISHED -> new ReduceAttemptFinishedEvent();
            case EventType.REDUCE_ATTEMPT_FAILED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.REDUCE_ATTEMPT_KILLED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.SETUP_ATTEMPT_STARTED -> new TaskAttemptStartedEvent();
            case EventType.SETUP_ATTEMPT_FINISHED -> new TaskAttemptFinishedEvent();
            case EventType.SETUP_ATTEMPT_FAILED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.SETUP_ATTEMPT_KILLED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.CLEANUP_ATTEMPT_STARTED -> new TaskAttemptStartedEvent();
            case EventType.CLEANUP_ATTEMPT_FINISHED -> new TaskAttemptFinishedEvent();
            case EventType.CLEANUP_ATTEMPT_FAILED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.CLEANUP_ATTEMPT_KILLED -> new TaskAttemptUnsuccessfulCompletionEvent();
            case EventType.AM_STARTED -> new AMStartedEvent();
            default -> throw new RuntimeException("unexpected event type: " + wrapper.getType());
        };
        result.setDatum(wrapper.getEvent());
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    static Counters fromAvro(JhCounters counters) {
        Counters result = new Counters();
        if (counters != null) {
            for (JhCounterGroup g : counters.getGroups()) {
                CounterGroup group = (CounterGroup)result.addGroup(StringInterner.weakIntern((String)g.getName().toString()), StringInterner.weakIntern((String)g.getDisplayName().toString()));
                for (JhCounter c : g.getCounts()) {
                    group.addCounter(StringInterner.weakIntern((String)c.getName().toString()), StringInterner.weakIntern((String)c.getDisplayName().toString()), c.getValue());
                }
            }
        }
        return result;
    }
}

